/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.ClassPathEntry;
import proguard.io.DataEntryNameFilter;
import proguard.io.DataEntryReader;
import proguard.io.FilteredDataEntryReader;
import proguard.io.JarReader;
import proguard.util.ExtensionMatcher;
import proguard.util.FileNameParser;
import proguard.util.ListParser;

public class DataEntryReaderFactory {
    public static DataEntryReader createDataEntryReader(String messagePrefix, ClassPathEntry classPathEntry, DataEntryReader reader) {
        boolean isJar = classPathEntry.isJar();
        boolean isWar = classPathEntry.isWar();
        boolean isEar = classPathEntry.isEar();
        boolean isZip = classPathEntry.isZip();
        List filter = classPathEntry.getFilter();
        List jarFilter = classPathEntry.getJarFilter();
        List warFilter = classPathEntry.getWarFilter();
        List earFilter = classPathEntry.getEarFilter();
        List zipFilter = classPathEntry.getZipFilter();
        System.out.println(messagePrefix + (isJar ? "jar" : (isWar ? "war" : (isEar ? "ear" : (isZip ? "zip" : "directory")))) + " [" + classPathEntry.getName() + "]" + (filter != null || jarFilter != null || warFilter != null || earFilter != null || zipFilter != null ? " (filtered)" : ""));
        if (filter != null) {
            reader = new FilteredDataEntryReader(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(filter)), reader);
        }
        reader = DataEntryReaderFactory.wrapInJarReader(reader, isJar, jarFilter, ".jar");
        if (!isJar) {
            reader = DataEntryReaderFactory.wrapInJarReader(reader, isWar, warFilter, ".war");
            if (!isWar) {
                reader = DataEntryReaderFactory.wrapInJarReader(reader, isEar, earFilter, ".ear");
                if (!isEar) {
                    reader = DataEntryReaderFactory.wrapInJarReader(reader, isZip, zipFilter, ".zip");
                }
            }
        }
        return reader;
    }

    private static DataEntryReader wrapInJarReader(DataEntryReader reader, boolean isJar, List jarFilter, String jarExtension) {
        DataEntryReader jarReader = new JarReader(reader);
        if (isJar) {
            return jarReader;
        }
        if (jarFilter != null) {
            jarReader = new FilteredDataEntryReader(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(jarFilter)), jarReader);
        }
        return new FilteredDataEntryReader(new DataEntryNameFilter(new ExtensionMatcher(jarExtension)), jarReader, reader);
    }
}

