/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class ClassAccessFilter
implements ClassVisitor {
    private final int requiredSetAccessFlags;
    private final int requiredUnsetAccessFlags;
    private final ClassVisitor classVisitor;

    public ClassAccessFilter(int requiredSetAccessFlags, int requiredUnsetAccessFlags, ClassVisitor classVisitor) {
        this.requiredSetAccessFlags = requiredSetAccessFlags;
        this.requiredUnsetAccessFlags = requiredUnsetAccessFlags;
        this.classVisitor = classVisitor;
    }

    public void visitProgramClass(ProgramClass programClass) {
        if (this.accepted(programClass.getAccessFlags())) {
            this.classVisitor.visitProgramClass(programClass);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        if (this.accepted(libraryClass.getAccessFlags())) {
            this.classVisitor.visitLibraryClass(libraryClass);
        }
    }

    private boolean accepted(int accessFlags) {
        return (this.requiredSetAccessFlags & ~accessFlags) == 0 && (this.requiredUnsetAccessFlags & accessFlags) == 0;
    }
}

