/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.info.MethodOptimizationInfo;

public class SuperInvocationMarker
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor {
    private boolean invokesSuperMethods;

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        if (constantInstruction.opcode == -73) {
            this.invokesSuperMethods = false;
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
            if (this.invokesSuperMethods) {
                SuperInvocationMarker.setInvokesSuperMethods(method);
            }
        }
    }

    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        this.invokesSuperMethods = !clazz.equals(refConstant.referencedClass) && !refConstant.getName(clazz).equals("<init>");
    }

    private static void setInvokesSuperMethods(Method method) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (info != null) {
            info.setInvokesSuperMethods();
        }
    }

    public static boolean invokesSuperMethods(Method method) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return info == null || info.invokesSuperMethods();
    }
}

