/*
 * Decompiled with CFR 0.152.
 */
package nl.bravobit.ffmpeg;

import android.os.AsyncTask;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import nl.bravobit.ffmpeg.CommandResult;
import nl.bravobit.ffmpeg.FFcommandExecuteResponseHandler;
import nl.bravobit.ffmpeg.FFtask;
import nl.bravobit.ffmpeg.Log;
import nl.bravobit.ffmpeg.ShellCommand;
import nl.bravobit.ffmpeg.Util;

class FFcommandExecuteAsyncTask
extends AsyncTask<Void, String, CommandResult>
implements FFtask {
    private final String[] cmd;
    private Map<String, String> environment;
    private final FFcommandExecuteResponseHandler ffmpegExecuteResponseHandler;
    private final ShellCommand shellCommand;
    private final long timeout;
    private long startTime;
    private Process process;
    private String output = "";
    private boolean quitPending;

    FFcommandExecuteAsyncTask(String[] cmd, Map<String, String> environment, long timeout, FFcommandExecuteResponseHandler ffmpegExecuteResponseHandler) {
        this.cmd = cmd;
        this.timeout = timeout;
        this.environment = environment;
        this.ffmpegExecuteResponseHandler = ffmpegExecuteResponseHandler;
        this.shellCommand = new ShellCommand();
    }

    protected void onPreExecute() {
        this.startTime = System.currentTimeMillis();
        if (this.ffmpegExecuteResponseHandler != null) {
            this.ffmpegExecuteResponseHandler.onStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CommandResult doInBackground(Void ... params) {
        try {
            this.process = this.shellCommand.run(this.cmd, this.environment);
            if (this.process == null) {
                CommandResult commandResult = CommandResult.getDummyFailureResponse();
                return commandResult;
            }
            Log.d("Running publishing updates method");
            this.checkAndUpdateProcess();
            CommandResult commandResult = CommandResult.getOutputFromProcess(this.process);
            return commandResult;
        }
        catch (TimeoutException e) {
            Log.e("FFmpeg binary timed out", e);
            CommandResult commandResult = new CommandResult(false, e.getMessage());
            return commandResult;
        }
        catch (Exception e) {
            Log.e("Error running FFmpeg binary", e);
        }
        finally {
            Util.destroyProcess(this.process);
        }
        return CommandResult.getDummyFailureResponse();
    }

    protected void onProgressUpdate(String ... values) {
        if (values != null && values[0] != null && this.ffmpegExecuteResponseHandler != null) {
            this.ffmpegExecuteResponseHandler.onProgress(values[0]);
        }
    }

    protected void onPostExecute(CommandResult commandResult) {
        if (this.ffmpegExecuteResponseHandler != null) {
            this.output = this.output + commandResult.output;
            if (commandResult.success) {
                this.ffmpegExecuteResponseHandler.onSuccess(this.output);
            } else {
                this.ffmpegExecuteResponseHandler.onFailure(this.output);
            }
            this.ffmpegExecuteResponseHandler.onFinish();
        }
    }

    private void checkAndUpdateProcess() throws TimeoutException, InterruptedException {
        while (!Util.isProcessCompleted(this.process)) {
            if (Util.isProcessCompleted(this.process)) {
                return;
            }
            if (this.timeout != Long.MAX_VALUE && System.currentTimeMillis() > this.startTime + this.timeout) {
                throw new TimeoutException("FFmpeg binary timed out");
            }
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
                while ((line = reader.readLine()) != null) {
                    if (this.isCancelled()) {
                        this.process.destroy();
                        this.process.waitFor();
                        return;
                    }
                    if (this.quitPending) {
                        this.sendQ();
                        this.process = null;
                        return;
                    }
                    this.output = this.output + line + "\n";
                    this.publishProgress(new String[]{line});
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isProcessCompleted() {
        return Util.isProcessCompleted(this.process);
    }

    @Override
    public boolean killRunningProcess() {
        return Util.killAsync(this);
    }

    @Override
    public void sendQuitSignal() {
        this.quitPending = true;
    }

    private void sendQ() {
        OutputStream outputStream = this.process.getOutputStream();
        try {
            outputStream.write("q\n".getBytes());
            outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

