/*
 * Decompiled with CFR 0.152.
 */
package nl.bravobit.ffmpeg;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.Map;
import nl.bravobit.ffmpeg.CpuArch;
import nl.bravobit.ffmpeg.CpuArchHelper;
import nl.bravobit.ffmpeg.FFbinaryContextProvider;
import nl.bravobit.ffmpeg.FFbinaryInterface;
import nl.bravobit.ffmpeg.FFcommandExecuteAsyncTask;
import nl.bravobit.ffmpeg.FFcommandExecuteResponseHandler;
import nl.bravobit.ffmpeg.FFtask;
import nl.bravobit.ffmpeg.FileUtils;
import nl.bravobit.ffmpeg.Log;
import nl.bravobit.ffmpeg.Util;

public class FFprobe
implements FFbinaryInterface {
    private static final int VERSION = 17;
    private static final String KEY_PREF_VERSION = "ffprobe_version";
    private final FFbinaryContextProvider context;
    private static final long MINIMUM_TIMEOUT = 10000L;
    private long timeout = Long.MAX_VALUE;
    private static FFprobe instance = null;

    private FFprobe(FFbinaryContextProvider context) {
        this.context = context;
        Log.setDebug(Util.isDebug(this.context.provide()));
    }

    public static FFprobe getInstance(final Context context) {
        if (instance == null) {
            instance = new FFprobe(new FFbinaryContextProvider(){

                @Override
                public Context provide() {
                    return context;
                }
            });
        }
        return instance;
    }

    @Override
    public boolean isSupported() {
        CpuArch cpuArch = CpuArchHelper.getCpuArch();
        if (cpuArch == CpuArch.NONE) {
            Log.e("arch not supported");
            return false;
        }
        File ffprobe = FileUtils.getFFprobe(this.context.provide());
        SharedPreferences settings = this.context.provide().getSharedPreferences("ffmpeg_prefs", 0);
        int version = settings.getInt(KEY_PREF_VERSION, 0);
        if (!ffprobe.exists() || version < 17) {
            String prefix = "arm/";
            if (cpuArch == CpuArch.x86) {
                prefix = "x86/";
            }
            Log.d("file does not exist, creating it...");
            try {
                InputStream inputStream = this.context.provide().getAssets().open(prefix + "ffprobe");
                if (!FileUtils.inputStreamToFile(inputStream, ffprobe)) {
                    return false;
                }
                Log.d("successfully wrote ffprobe file!");
                settings.edit().putInt(KEY_PREF_VERSION, 17).apply();
            }
            catch (IOException e) {
                Log.e("error while opening assets", e);
                return false;
            }
        }
        if (!ffprobe.canExecute()) {
            try {
                try {
                    Runtime.getRuntime().exec("chmod -R 777 " + ffprobe.getAbsolutePath()).waitFor();
                }
                catch (InterruptedException e) {
                    Log.e("interrupted exception", e);
                    return false;
                }
                catch (IOException e) {
                    Log.e("io exception", e);
                    return false;
                }
                if (!ffprobe.canExecute() && !ffprobe.setExecutable(true)) {
                    Log.e("unable to make executable");
                    return false;
                }
            }
            catch (SecurityException e) {
                Log.e("security exception", e);
                return false;
            }
        }
        Log.d("ffprobe is ready!");
        return true;
    }

    @Override
    public FFtask execute(Map<String, String> environvenmentVars, String[] cmd, FFcommandExecuteResponseHandler ffcommandExecuteResponseHandler) {
        if (cmd.length != 0) {
            String[] ffprobeBinary = new String[]{FileUtils.getFFprobe(this.context.provide()).getAbsolutePath()};
            String[] command = FFprobe.concatenate(ffprobeBinary, cmd);
            FFcommandExecuteAsyncTask task = new FFcommandExecuteAsyncTask(command, environvenmentVars, this.timeout, ffcommandExecuteResponseHandler);
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
            return task;
        }
        throw new IllegalArgumentException("shell command cannot be empty");
    }

    private static <T> T[] concatenate(T[] a, T[] b) {
        int aLen = a.length;
        int bLen = b.length;
        Object[] c = (Object[])Array.newInstance(a.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    @Override
    public FFtask execute(String[] cmd, FFcommandExecuteResponseHandler ffcommandExecuteResponseHandler) {
        return this.execute(null, cmd, ffcommandExecuteResponseHandler);
    }

    @Override
    public boolean isCommandRunning(FFtask task) {
        return task != null && !task.isProcessCompleted();
    }

    @Override
    public boolean killRunningProcesses(FFtask task) {
        return task != null && task.killRunningProcess();
    }

    @Override
    public void setTimeout(long timeout) {
        if (timeout >= 10000L) {
            this.timeout = timeout;
        }
    }
}

