/*
 * Decompiled with CFR 0.152.
 */
package nl.bravobit.ffmpeg;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import nl.bravobit.ffmpeg.FFbinaryObserver;
import nl.bravobit.ffmpeg.Log;

class Util {
    Util() {
    }

    static boolean isDebug(Context context) {
        return (context.getApplicationContext().getApplicationInfo().flags & 2) != 0;
    }

    static String convertInputStreamToString(InputStream inputStream) {
        try {
            String str;
            BufferedReader r = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder sb = new StringBuilder();
            while ((str = r.readLine()) != null) {
                sb.append(str);
            }
            return sb.toString();
        }
        catch (IOException e) {
            Log.e("error converting input stream to string", e);
            return null;
        }
    }

    static void destroyProcess(Process process) {
        if (process != null) {
            try {
                process.destroy();
            }
            catch (Exception e) {
                Log.e("progress destroy error", e);
            }
        }
    }

    static boolean killAsync(AsyncTask asyncTask) {
        return asyncTask != null && !asyncTask.isCancelled() && asyncTask.cancel(true);
    }

    static boolean isProcessCompleted(Process process) {
        try {
            if (process == null) {
                return true;
            }
            process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return false;
        }
    }

    static FFbinaryObserver observeOnce(final ObservePredicate predicate, final Runnable run, final int timeout) {
        final Handler observer = new Handler();
        FFbinaryObserver observeAction = new FFbinaryObserver(){
            private boolean canceled = false;
            private int timeElapsed = 0;

            @Override
            public void run() {
                if (this.timeElapsed + 40 > timeout) {
                    this.cancel();
                }
                this.timeElapsed += 40;
                if (this.canceled) {
                    return;
                }
                boolean readyToProceed = false;
                try {
                    readyToProceed = predicate.isReadyToProceed();
                }
                catch (Exception e) {
                    Log.v("Observing " + e.getMessage());
                    observer.postDelayed((Runnable)this, 40L);
                    return;
                }
                if (readyToProceed) {
                    Log.v("Observed");
                    run.run();
                } else {
                    Log.v("Observing");
                    observer.postDelayed((Runnable)this, 40L);
                }
            }

            @Override
            public void cancel() {
                this.canceled = true;
            }
        };
        observer.post((Runnable)observeAction);
        return observeAction;
    }

    public static interface ObservePredicate {
        public Boolean isReadyToProceed();
    }
}

