/*
 * Decompiled with CFR 0.152.
 */
package nl.qbusict.cupboard;

import android.database.Cursor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import nl.qbusict.cupboard.PreferredColumnOrderCursorWrapper;
import nl.qbusict.cupboard.convert.EntityConverter;

public class QueryResultIterable<T>
implements Iterable<T> {
    private final Cursor mCursor;
    private final EntityConverter<T> mTranslator;
    private final int mPosition;

    QueryResultIterable(Cursor cursor, EntityConverter<T> translator) {
        this.mPosition = cursor.getPosition() > -1 ? cursor.getPosition() : -1;
        this.mCursor = cursor;
        this.mTranslator = translator;
    }

    @Override
    public Iterator<T> iterator() {
        this.mCursor.moveToPosition(this.mPosition);
        return new QueryResultIterator<T>(this.mCursor, this.mTranslator);
    }

    public void close() {
        if (!this.mCursor.isClosed()) {
            this.mCursor.close();
        }
    }

    public Cursor getCursor() {
        return this.mCursor;
    }

    public T get() {
        return this.get(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(boolean close) {
        try {
            Iterator<T> itr = this.iterator();
            if (itr.hasNext()) {
                T t = itr.next();
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            if (close) {
                this.close();
            }
        }
    }

    public List<T> list() {
        return this.list(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> list(boolean close) {
        ArrayList<T> result = new ArrayList<T>(this.mCursor.getCount());
        try {
            for (T obj : this) {
                result.add(obj);
            }
            ArrayList<T> arrayList = result;
            return arrayList;
        }
        finally {
            if (close) {
                this.close();
            }
        }
    }

    static class QueryResultIterator<E>
    implements Iterator<E> {
        private final Cursor mCursor;
        private final EntityConverter<E> mTranslator;
        private final int mCount;
        private int mPosition;

        public QueryResultIterator(Cursor cursor, EntityConverter<E> translator) {
            this.mCursor = new PreferredColumnOrderCursorWrapper(cursor, translator.getColumns());
            this.mTranslator = translator;
            this.mPosition = cursor.getPosition();
            this.mCount = cursor.getCount();
            if (this.mPosition != -1) {
                --this.mPosition;
            }
        }

        @Override
        public boolean hasNext() {
            return this.mPosition < this.mCount - 1;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.mCursor.moveToPosition(++this.mPosition);
            return this.mTranslator.fromCursor(this.mCursor);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

