/*
 * Decompiled with CFR 0.152.
 */
package nl.qbusict.cupboard.convert;

import android.content.ContentValues;
import android.database.Cursor;
import java.util.List;
import nl.qbusict.cupboard.annotation.Index;

public interface EntityConverter<T> {
    public T fromCursor(Cursor var1);

    public void toValues(T var1, ContentValues var2);

    public List<Column> getColumns();

    public void setId(Long var1, T var2);

    public Long getId(T var1);

    public String getTable();

    public static class Column {
        public final String name;
        public final ColumnType type;
        public final Index index;

        public Column(String name, ColumnType type) {
            this(name, type, null);
        }

        public Column(String name, ColumnType type, Index index) {
            this.name = name;
            this.type = type;
            this.index = index;
        }

        public int hashCode() {
            return 37 * this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Column) {
                Column c = (Column)o;
                return c.name.equals(this.name) && c.type == this.type;
            }
            if (o instanceof String) {
                return this.name.equals(o);
            }
            return super.equals(o);
        }
    }

    public static enum ColumnType {
        TEXT,
        INTEGER,
        REAL,
        BLOB,
        JOIN;

    }
}

