/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.crystalball.simulator;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.activiti.crystalball.simulator.AbstractSimulationRun;
import org.activiti.crystalball.simulator.EventCalendar;
import org.activiti.crystalball.simulator.SimulationEvent;
import org.activiti.crystalball.simulator.SimulationEventHandler;
import org.activiti.crystalball.simulator.SimulationRunContext;
import org.activiti.crystalball.simulator.impl.AcquireJobNotificationEventHandler;
import org.activiti.crystalball.simulator.impl.NoopEventHandler;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.ProcessEngineImpl;
import org.activiti.engine.impl.jobexecutor.JobExecutor;

public class SimpleSimulationRun
extends AbstractSimulationRun {
    protected EventCalendar eventCalendar;
    protected Date simulationStartDate = new Date(0L);
    protected Date dueDate = null;

    protected SimpleSimulationRun(Builder builder) {
        super(builder.eventHandlers);
        this.eventCalendar = builder.getEventCalendar();
        this.processEngine = builder.getProcessEngine();
        this.eventHandlerMap.put("END_SIMULATION", new NoopEventHandler());
        if (builder.getJobExecutor() != null) {
            this.eventHandlerMap.put("ACQUIRE_JOB_NOTIFICATION_EVENT", new AcquireJobNotificationEventHandler(builder.getJobExecutor()));
        }
    }

    @Override
    public void close() {
        SimulationRunContext.getEventCalendar().clear();
        SimulationRunContext.removeEventCalendar();
        SimulationRunContext.getProcessEngine().close();
        SimulationRunContext.removeProcessEngine();
    }

    @Override
    protected void initSimulationRunContext(VariableScope execution) {
        try {
            SimulationRunContext.setEventCalendar(this.eventCalendar);
            SimulationRunContext.setProcessEngine(this.processEngine);
            SimulationRunContext.setExecution(execution);
            SimulationRunContext.getClock().setCurrentTime(this.simulationStartDate);
            if (this.dueDate != null) {
                SimulationRunContext.getEventCalendar().addEvent(new SimulationEvent.Builder("END_SIMULATION").simulationTime(this.dueDate.getTime()).build());
            }
        }
        catch (Exception e) {
            throw new ActivitiException("Unable to initialize simulation run", (Throwable)e);
        }
    }

    @Override
    protected boolean simulationEnd(SimulationEvent event) {
        if (event != null && event.getType().equals("BREAK")) {
            return true;
        }
        if (this.dueDate != null) {
            return event == null || SimulationRunContext.getClock().getCurrentTime().after(this.dueDate);
        }
        return event == null;
    }

    public static class Builder {
        private Map<String, SimulationEventHandler> eventHandlers = Collections.emptyMap();
        private ProcessEngineImpl processEngine;
        private EventCalendar eventCalendar;
        private JobExecutor jobExecutor;

        public JobExecutor getJobExecutor() {
            return this.jobExecutor;
        }

        public Builder jobExecutor(JobExecutor jobExecutor) {
            this.jobExecutor = jobExecutor;
            return this;
        }

        public ProcessEngineImpl getProcessEngine() {
            return this.processEngine;
        }

        public Builder processEngine(ProcessEngineImpl processEngine) {
            this.processEngine = processEngine;
            return this;
        }

        public EventCalendar getEventCalendar() {
            return this.eventCalendar;
        }

        public Builder eventCalendar(EventCalendar eventCalendar) {
            this.eventCalendar = eventCalendar;
            return this;
        }

        public Builder eventHandlers(Map<String, SimulationEventHandler> eventHandlersMap) {
            this.eventHandlers = eventHandlersMap;
            return this;
        }

        public SimpleSimulationRun build() {
            return new SimpleSimulationRun(this);
        }
    }
}

