/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.crystalball.simulator.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.activiti.crystalball.simulator.SimulationEvent;
import org.activiti.crystalball.simulator.SimulationEventHandler;
import org.activiti.crystalball.simulator.SimulationRunContext;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.engine.repository.DeploymentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployResourcesEventHandler
implements SimulationEventHandler {
    private static Logger log = LoggerFactory.getLogger(DeployResourcesEventHandler.class);
    protected String resourcesKey;

    public DeployResourcesEventHandler(String resourcesKey) {
        this.resourcesKey = resourcesKey;
    }

    @Override
    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(SimulationEvent event) {
        Map resources = (Map)event.getProperty(this.resourcesKey);
        ArrayList<ByteArrayInputStream> inputStreams = new ArrayList<ByteArrayInputStream>();
        try {
            DeploymentBuilder deploymentBuilder = SimulationRunContext.getRepositoryService().createDeployment();
            for (ResourceEntity resource : resources.values()) {
                log.debug("adding resource [{}] to deploymnet", (Object)resource.getName());
                ByteArrayInputStream is = new ByteArrayInputStream(resource.getBytes());
                deploymentBuilder.addInputStream(resource.getName(), (InputStream)is);
                inputStreams.add(is);
            }
            deploymentBuilder.deploy();
        }
        finally {
            for (InputStream inputStream : inputStreams) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("Unable to close resource input stream {}", (Object)inputStream);
                }
            }
        }
    }
}

