/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import java.util.ArrayList;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractBpmnParseHandler;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.activiti.engine.impl.jobexecutor.TimerDeclarationType;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.apache.commons.lang3.StringUtils;

public class TimerEventDefinitionParseHandler
extends AbstractBpmnParseHandler<TimerEventDefinition> {
    public static final String PROPERTYNAME_START_TIMER = "timerStart";

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return TimerEventDefinition.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, TimerEventDefinition timerEventDefinition) {
        ActivityImpl timerActivity = bpmnParse.getCurrentActivity();
        if (bpmnParse.getCurrentFlowElement() instanceof StartEvent) {
            ProcessDefinitionEntity processDefinition = bpmnParse.getCurrentProcessDefinition();
            timerActivity.setProperty("type", "startTimerEvent");
            TimerDeclarationImpl timerDeclaration = this.createTimer(bpmnParse, timerEventDefinition, timerActivity, "timer-start-event");
            timerDeclaration.setJobHandlerConfiguration(processDefinition.getKey());
            ArrayList<TimerDeclarationImpl> timerDeclarations = (ArrayList<TimerDeclarationImpl>)processDefinition.getProperty(PROPERTYNAME_START_TIMER);
            if (timerDeclarations == null) {
                timerDeclarations = new ArrayList<TimerDeclarationImpl>();
                processDefinition.setProperty(PROPERTYNAME_START_TIMER, timerDeclarations);
            }
            timerDeclarations.add(timerDeclaration);
        } else if (bpmnParse.getCurrentFlowElement() instanceof IntermediateCatchEvent) {
            timerActivity.setProperty("type", "intermediateTimer");
            TimerDeclarationImpl timerDeclaration = this.createTimer(bpmnParse, timerEventDefinition, timerActivity, "timer-intermediate-transition");
            if (this.getPrecedingEventBasedGateway(bpmnParse, (IntermediateCatchEvent)bpmnParse.getCurrentFlowElement()) != null) {
                this.addTimerDeclaration(timerActivity.getParent(), timerDeclaration);
            } else {
                this.addTimerDeclaration(timerActivity, timerDeclaration);
                timerActivity.setScope(true);
            }
        } else if (bpmnParse.getCurrentFlowElement() instanceof BoundaryEvent) {
            timerActivity.setProperty("type", "boundaryTimer");
            TimerDeclarationImpl timerDeclaration = this.createTimer(bpmnParse, timerEventDefinition, timerActivity, "timer-transition");
            BoundaryEvent boundaryEvent = (BoundaryEvent)bpmnParse.getCurrentFlowElement();
            boolean interrupting = boundaryEvent.isCancelActivity();
            if (interrupting) {
                timerDeclaration.setInterruptingTimer(true);
            }
            this.addTimerDeclaration(timerActivity.getParent(), timerDeclaration);
            if (timerActivity.getParent() instanceof ActivityImpl) {
                ((ActivityImpl)timerActivity.getParent()).setScope(true);
            }
            timerActivity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createBoundaryEventActivityBehavior((BoundaryEvent)bpmnParse.getCurrentFlowElement(), interrupting, timerActivity));
        }
    }

    protected TimerDeclarationImpl createTimer(BpmnParse bpmnParse, TimerEventDefinition timerEventDefinition, ScopeImpl timerActivity, String jobHandlerType) {
        TimerDeclarationType type = null;
        Expression expression = null;
        ExpressionManager expressionManager = bpmnParse.getExpressionManager();
        if (StringUtils.isNotEmpty((CharSequence)timerEventDefinition.getTimeDate())) {
            type = TimerDeclarationType.DATE;
            expression = expressionManager.createExpression(timerEventDefinition.getTimeDate());
        } else if (StringUtils.isNotEmpty((CharSequence)timerEventDefinition.getTimeCycle())) {
            type = TimerDeclarationType.CYCLE;
            expression = expressionManager.createExpression(timerEventDefinition.getTimeCycle());
        } else if (StringUtils.isNotEmpty((CharSequence)timerEventDefinition.getTimeDuration())) {
            type = TimerDeclarationType.DURATION;
            expression = expressionManager.createExpression(timerEventDefinition.getTimeDuration());
        }
        if (expression == null) {
            bpmnParse.getBpmnModel().addProblem("Timer needs configuration (either timeDate, timeCycle or timeDuration is needed).", (BaseElement)timerEventDefinition);
        }
        TimerDeclarationImpl timerDeclaration = new TimerDeclarationImpl(expression, type, jobHandlerType);
        timerDeclaration.setJobHandlerConfiguration(timerActivity.getId());
        timerDeclaration.setExclusive(true);
        return timerDeclaration;
    }

    protected void addTimerDeclaration(ScopeImpl scope, TimerDeclarationImpl timerDeclaration) {
        ArrayList<TimerDeclarationImpl> timerDeclarations = (ArrayList<TimerDeclarationImpl>)scope.getProperty("timerDeclarations");
        if (timerDeclarations == null) {
            timerDeclarations = new ArrayList<TimerDeclarationImpl>();
            scope.setProperty("timerDeclarations", timerDeclarations);
        }
        timerDeclarations.add(timerDeclaration);
    }
}

