/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.asyncexecutor;

import java.util.concurrent.atomic.AtomicBoolean;
import org.activiti.engine.ActivitiOptimisticLockingException;
import org.activiti.engine.impl.asyncexecutor.AcquiredJobEntities;
import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.engine.impl.cmd.AcquireAsyncJobsDueCmd;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcquireAsyncJobsDueRunnable
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(AcquireAsyncJobsDueRunnable.class);
    protected final AsyncExecutor asyncExecutor;
    protected volatile boolean isInterrupted = false;
    protected final Object MONITOR = new Object();
    protected final AtomicBoolean isWaiting = new AtomicBoolean(false);
    protected long millisToWait = 0L;

    public AcquireAsyncJobsDueRunnable(AsyncExecutor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        log.info("{} starting to acquire async jobs due");
        CommandExecutor commandExecutor = this.asyncExecutor.getCommandExecutor();
        while (!this.isInterrupted) {
            try {
                AcquiredJobEntities acquiredJobs = commandExecutor.execute(new AcquireAsyncJobsDueCmd(this.asyncExecutor));
                boolean allJobsSuccessfullyOffered = true;
                for (JobEntity job : acquiredJobs.getJobs()) {
                    boolean jobSuccessFullyOffered = this.asyncExecutor.executeAsyncJob(job);
                    if (jobSuccessFullyOffered) continue;
                    allJobsSuccessfullyOffered = false;
                }
                this.millisToWait = this.asyncExecutor.getDefaultAsyncJobAcquireWaitTimeInMillis();
                int jobsAcquired = acquiredJobs.size();
                if (jobsAcquired >= this.asyncExecutor.getMaxAsyncJobsDuePerAcquisition()) {
                    this.millisToWait = 0L;
                }
                if (this.millisToWait == 0L && !allJobsSuccessfullyOffered) {
                    this.millisToWait = this.asyncExecutor.getDefaultQueueSizeFullWaitTimeInMillis();
                }
            }
            catch (ActivitiOptimisticLockingException optimisticLockingException) {
                if (log.isDebugEnabled()) {
                    log.debug("Optimistic locking exception during async job acquisition. If you have multiple async executors running against the same database, this exception means that this thread tried to acquire a due async job, which already was acquired by another async executor acquisition thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple async executor acquisition threads running against the same database. Exception message: {}", (Object)optimisticLockingException.getMessage());
                }
            }
            catch (Throwable e) {
                log.error("exception during async job acquisition: {}", (Object)e.getMessage(), (Object)e);
                this.millisToWait = this.asyncExecutor.getDefaultAsyncJobAcquireWaitTimeInMillis();
            }
            if (this.millisToWait <= 0L) continue;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("async job acquisition thread sleeping for {} millis", (Object)this.millisToWait);
                }
                Object e = this.MONITOR;
                synchronized (e) {
                    if (!this.isInterrupted) {
                        this.isWaiting.set(true);
                        this.MONITOR.wait(this.millisToWait);
                    }
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("async job acquisition thread woke up");
            }
            catch (InterruptedException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("async job acquisition wait interrupted");
            }
            finally {
                this.isWaiting.set(false);
            }
        }
        log.info("{} stopped async job due acquisition");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.MONITOR;
        synchronized (object) {
            this.isInterrupted = true;
            if (this.isWaiting.compareAndSet(true, false)) {
                this.MONITOR.notifyAll();
            }
        }
    }

    public long getMillisToWait() {
        return this.millisToWait;
    }

    public void setMillisToWait(long millisToWait) {
        this.millisToWait = millisToWait;
    }
}

