/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.process.variable;

import java.text.MessageFormat;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Date;

public class DateFormatterProvider {
    private String dateFormatPattern;
    private ZoneId zoneId = ZoneOffset.UTC;

    public DateFormatterProvider(String dateFormatPattern) {
        this.dateFormatPattern = dateFormatPattern;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.dateFormatPattern = dateFormatPattern;
    }

    public Date parse(String value) throws DateTimeException {
        DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern(this.getDateFormatPattern()).toFormatter().withZone(this.getZoneId());
        try {
            LocalDateTime localDateTime = dateTimeFormatter.parse((CharSequence)value, LocalDateTime::from);
            return Date.from(localDateTime.atZone(this.getZoneId()).toInstant());
        }
        catch (DateTimeException e) {
            LocalDate localDate = dateTimeFormatter.parse((CharSequence)String.valueOf(value), LocalDate::from);
            return Date.from(localDate.atStartOfDay().atZone(this.getZoneId()).toInstant());
        }
    }

    public Date toDate(Object value) {
        if (value instanceof String) {
            return this.parse((String)value);
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        throw new DateTimeException(MessageFormat.format("Error while parsing date. Type: {0}, value: {1}", value.getClass().getName(), value));
    }
}

