/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus.android.webview;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Pair;
import android.webkit.ConsoleMessage;
import android.webkit.JavascriptInterface;
import android.webkit.WebBackForwardList;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.adblockplus.libadblockplus.FilterEngine;
import org.adblockplus.libadblockplus.android.AdblockEngine;
import org.adblockplus.libadblockplus.android.AdblockEngineProvider;
import org.adblockplus.libadblockplus.android.SingleInstanceEngineProvider;
import org.adblockplus.libadblockplus.android.Utils;
import org.adblockplus.libadblockplus.android.webview.CombinedSiteKeyExtractor;
import org.adblockplus.libadblockplus.android.webview.ProxyWebChromeClient;
import org.adblockplus.libadblockplus.android.webview.ProxyWebViewClient;
import org.adblockplus.libadblockplus.android.webview.SiteKeyExtractor;
import org.adblockplus.libadblockplus.android.webview.content_type.ContentTypeDetector;
import org.adblockplus.libadblockplus.android.webview.content_type.HeadersContentTypeDetector;
import org.adblockplus.libadblockplus.android.webview.content_type.OrderedContentTypeDetector;
import org.adblockplus.libadblockplus.android.webview.content_type.UrlFileExtensionTypeDetector;
import org.adblockplus.libadblockplus.sitekey.PublicKeyHolderImpl;
import org.adblockplus.libadblockplus.sitekey.SiteKeysConfiguration;
import timber.log.Timber;

public class AdblockWebView
extends WebView {
    private static final String ASSETS_CHARSET_NAME = "UTF-8";
    private static final String BRIDGE_TOKEN = "{{BRIDGE}}";
    private static final String DEBUG_TOKEN = "{{DEBUG}}";
    private static final String HIDE_TOKEN = "{{HIDE}}";
    private static final String HIDDEN_TOKEN = "{{HIDDEN_FLAG}}";
    private static final String SITEKEY_EXTRACTED_TOKEN = "{{SITEKEY_EXTRACTED_FLAG}}";
    private static final String BRIDGE = "jsBridge";
    private static final String EMPTY_ELEMHIDE_STRING = "";
    private static final String EMPTY_ELEMHIDE_ARRAY_STRING = "[]";
    private OrderedContentTypeDetector contentTypeDetector;
    private final AtomicReference<AdblockEngineProvider> providerReference = new AtomicReference();
    private Integer loadError;
    private ProxyWebChromeClient intWebChromeClient;
    private ProxyWebViewClient intWebViewClient;
    private final Map<String, String> url2Referrer = Collections.synchronizedMap(new HashMap());
    private final Map<String, Pair<String, String>> url2Stylesheets = Collections.synchronizedMap(new HashMap());
    private final AtomicReference<String> navigationUrl = new AtomicReference();
    private String injectJs;
    private String elemhideBlockedJs;
    private final AtomicReference<OptionalBoolean> adblockEnabled = new AtomicReference<OptionalBoolean>(OptionalBoolean.UNDEFINED);
    private boolean loading;
    private String elementsHiddenFlag;
    private String sitekeyExtractedFlag;
    private SiteKeyExtractor siteKeyExtractor;
    private final AtomicReference<EventsListener> eventsListenerAtomicReference = new AtomicReference();
    private final AtomicReference<SiteKeysConfiguration> siteKeysConfiguration = new AtomicReference();
    private final AtomicBoolean jsInIframesEnabled = new AtomicBoolean(false);
    private final AdblockEngine.SettingsChangedListener engineSettingsChangedCb = new AdblockEngine.SettingsChangedListener(){

        public void onEnableStateChanged(boolean enabled) {
            OptionalBoolean newValue = OptionalBoolean.from(enabled);
            OptionalBoolean oldValue = AdblockWebView.this.adblockEnabled.getAndSet(newValue);
            if (oldValue != OptionalBoolean.UNDEFINED && oldValue != newValue) {
                Timber.d((String)"Filter Engine status changed, enable status is %s", (Object[])new Object[]{newValue});
                AdblockWebView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        AdblockWebView.this.clearCache(true);
                    }
                });
            }
        }
    };
    private final AdblockEngineProvider.EngineCreatedListener engineCreatedCb = new AdblockEngineProvider.EngineCreatedListener(){

        public void onAdblockEngineCreated(AdblockEngine engine) {
            AdblockWebView.this.adblockEnabled.set(OptionalBoolean.from(engine.isEnabled()));
            Timber.d((String)"Filter Engine created, enable status is %s", (Object[])new Object[]{AdblockWebView.this.adblockEnabled.get()});
            engine.addSettingsChangedListener(AdblockWebView.this.engineSettingsChangedCb);
        }
    };
    private final AdblockEngineProvider.EngineDisposedListener engineDisposedCb = new AdblockEngineProvider.EngineDisposedListener(){

        public void onAdblockEngineDisposed() {
            AdblockWebView.this.adblockEnabled.set(OptionalBoolean.UNDEFINED);
        }
    };

    public String getNavigationUrl() {
        return this.navigationUrl.get();
    }

    public AdblockWebView(Context context) {
        super(context);
        this.initAbp();
    }

    public AdblockWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAbp();
    }

    public AdblockWebView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAbp();
    }

    private EventsListener getEventsListener() {
        return this.eventsListenerAtomicReference.get();
    }

    public void setSiteKeysConfiguration(SiteKeysConfiguration siteKeysConfiguration) {
        this.siteKeysConfiguration.set(siteKeysConfiguration);
        this.siteKeyExtractor.setSiteKeysConfiguration(siteKeysConfiguration);
    }

    public SiteKeysConfiguration getSiteKeysConfiguration() {
        return this.siteKeysConfiguration.get();
    }

    public void enableJsInIframes(boolean jsInIframesEnabled) throws IllegalStateException {
        if (jsInIframesEnabled && this.getSiteKeysConfiguration() == null) {
            throw new IllegalStateException("Site Keys configuration must be set (enabled) to use this feature!");
        }
        this.jsInIframesEnabled.set(jsInIframesEnabled);
    }

    public boolean getJsInIframesEnabled() {
        return this.jsInIframesEnabled.get() && this.getSiteKeysConfiguration() != null;
    }

    public void setEventsListener(EventsListener eventsListener) {
        this.eventsListenerAtomicReference.set(eventsListener);
    }

    public void setWebChromeClient(WebChromeClient client) {
        this.intWebChromeClient.setExtWebChromeClient(client);
    }

    public void setWebViewClient(WebViewClient client) {
        this.intWebViewClient.setExtWebViewClient(client);
    }

    public SiteKeyExtractor getSiteKeyExtractor() {
        return this.siteKeyExtractor;
    }

    public void setSiteKeyExtractor(SiteKeyExtractor extractor) {
        this.siteKeyExtractor = extractor;
    }

    public String getInjectJs() {
        return this.injectJs;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initAbp() {
        this.addJavascriptInterface((Object)this, BRIDGE);
        this.initRandom();
        this.buildInjectJs();
        this.getSettings().setJavaScriptEnabled(true);
        this.siteKeyExtractor = new CombinedSiteKeyExtractor(this);
        this.intWebChromeClient = new AdblockWebWebChromeClient(null);
        this.intWebViewClient = new AdblockWebViewClient(null);
        super.setWebChromeClient((WebChromeClient)this.intWebChromeClient);
        super.setWebViewClient((WebViewClient)this.intWebViewClient);
    }

    private AdblockEngineProvider getProvider() {
        return this.providerReference.get();
    }

    private String readScriptFile(String filename) throws IOException {
        return Utils.readAssetAsString((Context)this.getContext(), (String)filename, (String)ASSETS_CHARSET_NAME).replace(BRIDGE_TOKEN, BRIDGE).replace(DEBUG_TOKEN, "//").replace(HIDDEN_TOKEN, this.elementsHiddenFlag).replace(SITEKEY_EXTRACTED_TOKEN, this.sitekeyExtractedFlag);
    }

    private void runScript(String script) {
        Timber.d((String)"runScript started", (Object[])new Object[0]);
        this.evaluateJavascript(script, null);
        Timber.d((String)"runScript finished", (Object[])new Object[0]);
    }

    public void setProvider(final AdblockEngineProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Provider cannot be null");
        }
        if (this.getProvider() == provider) {
            return;
        }
        Runnable setRunnable = new Runnable(){

            @Override
            public void run() {
                AdblockWebView.this.providerReference.set(provider);
                ReentrantReadWriteLock.ReadLock lock = provider.getReadEngineLock();
                boolean locked = lock.tryLock();
                try {
                    AdblockWebView.this.getProvider().retain(true);
                    if (locked && AdblockWebView.this.getProvider().getEngine() != null) {
                        AdblockWebView.this.adblockEnabled.set(OptionalBoolean.from(AdblockWebView.this.getProvider().getEngine().isEnabled()));
                        Timber.d((String)"Filter Engine already created, enable status is %s", (Object[])new Object[]{AdblockWebView.this.adblockEnabled});
                        AdblockWebView.this.getProvider().getEngine().addSettingsChangedListener(AdblockWebView.this.engineSettingsChangedCb);
                    } else {
                        AdblockWebView.this.getProvider().addEngineCreatedListener(AdblockWebView.this.engineCreatedCb);
                        AdblockWebView.this.getProvider().addEngineDisposedListener(AdblockWebView.this.engineDisposedCb);
                    }
                }
                finally {
                    if (locked) {
                        lock.unlock();
                    }
                }
            }
        };
        if (this.getProvider() != null) {
            this.dispose(setRunnable);
        } else {
            setRunnable.run();
        }
    }

    private void tryInjectJs() {
        if (this.adblockEnabled.get() != OptionalBoolean.TRUE) {
            return;
        }
        if (this.loadError == null && this.injectJs != null) {
            Timber.d((String)"Injecting script", (Object[])new Object[0]);
            this.runScript(this.injectJs);
        }
    }

    private void clearReferrers() {
        Timber.d((String)"Clearing referrers", (Object[])new Object[0]);
        this.url2Referrer.clear();
    }

    private void clearStylesheets() {
        Timber.d((String)"Clearing stylesheet", (Object[])new Object[0]);
        this.url2Stylesheets.clear();
    }

    private List<String> buildFramesHierarchy(String urlWithoutFragment) {
        String currentTopLevelDomain;
        String navigationUrlLocal;
        ArrayList<String> referrerChain = new ArrayList<String>();
        String parent = urlWithoutFragment;
        while ((parent = this.url2Referrer.get(parent)) != null) {
            if (referrerChain.contains(parent)) {
                Timber.w((String)"Detected referrer loop, finished creating referrers list", (Object[])new Object[0]);
                break;
            }
            referrerChain.add(parent);
        }
        if (TextUtils.isEmpty((CharSequence)(navigationUrlLocal = this.navigationUrl.get()))) {
            return referrerChain;
        }
        String navigationUrlDomain = Utils.getDomain((String)navigationUrlLocal);
        if (TextUtils.isEmpty((CharSequence)navigationUrlDomain)) {
            Timber.e((String)("buildFramesHierarchy() failed to obtain a domain from url " + navigationUrlLocal), (Object[])new Object[0]);
            return referrerChain;
        }
        boolean canAddTopLevelParent = false;
        if (!referrerChain.isEmpty() && !navigationUrlDomain.equals(currentTopLevelDomain = Utils.getDomain((String)((String)referrerChain.get(referrerChain.size() - 1))))) {
            canAddTopLevelParent = true;
        }
        if (referrerChain.isEmpty() || canAddTopLevelParent) {
            Timber.d((String)"Adding top level referrer `%s` for `%s`", (Object[])new Object[]{navigationUrlLocal, urlWithoutFragment});
            referrerChain.add(navigationUrlLocal);
        }
        return referrerChain;
    }

    private ContentTypeDetector ensureContentTypeDetectorCreatedAndGet() {
        if (this.contentTypeDetector == null) {
            HeadersContentTypeDetector headersContentTypeDetector = new HeadersContentTypeDetector();
            UrlFileExtensionTypeDetector urlFileExtensionTypeDetector = new UrlFileExtensionTypeDetector();
            this.contentTypeDetector = new OrderedContentTypeDetector(headersContentTypeDetector, urlFileExtensionTypeDetector);
        }
        return this.contentTypeDetector;
    }

    private void notifyNavigation() {
        EventsListener eventsListener = this.getEventsListener();
        if (eventsListener != null) {
            eventsListener.onNavigation();
        }
    }

    private void notifyResourceBlocked(EventsListener.BlockedResourceInfo info) {
        EventsListener eventsListener = this.getEventsListener();
        if (eventsListener != null) {
            eventsListener.onResourceLoadingBlocked(info);
        }
    }

    private void notifyResourceAllowlisted(EventsListener.AllowlistedResourceInfo info) {
        EventsListener eventsListener = this.getEventsListener();
        if (eventsListener != null) {
            eventsListener.onResourceLoadingAllowlisted(info);
        }
    }

    private boolean isVisibleResource(FilterEngine.ContentType contentType) {
        return contentType == FilterEngine.ContentType.IMAGE || contentType == FilterEngine.ContentType.MEDIA || contentType == FilterEngine.ContentType.OBJECT || contentType == FilterEngine.ContentType.SUBDOCUMENT;
    }

    private void elemhideBlockedResource(final String url) {
        String filenameWithQuery;
        try {
            filenameWithQuery = Utils.extractPathWithQuery((String)url);
            if (filenameWithQuery.startsWith("/")) {
                filenameWithQuery = filenameWithQuery.substring(1);
            }
        }
        catch (MalformedURLException e) {
            Timber.e((String)("Failed to parse URI for blocked resource:" + url + ". Skipping element hiding"), (Object[])new Object[0]);
            return;
        }
        Timber.d((String)"Trying to elemhide visible blocked resource with url `%s` and path `%s`", (Object[])new Object[]{url, filenameWithQuery});
        final StringBuilder selectorBuilder = new StringBuilder();
        selectorBuilder.append("[src$='");
        selectorBuilder.append(filenameWithQuery);
        selectorBuilder.append("'], [srcset$='");
        selectorBuilder.append(filenameWithQuery);
        selectorBuilder.append("']");
        this.post(new Runnable(){

            @Override
            public void run() {
                StringBuilder scriptBuilder = new StringBuilder(AdblockWebView.this.elemhideBlockedJs);
                scriptBuilder.append("\n\n");
                scriptBuilder.append("elemhideForSelector(\"");
                scriptBuilder.append(url);
                scriptBuilder.append("\", \"");
                scriptBuilder.append(Utils.escapeJavaScriptString((String)selectorBuilder.toString()));
                scriptBuilder.append("\", 0)");
                AdblockWebView.this.evaluateJavascript(scriptBuilder.toString(), null);
            }
        });
    }

    private void initRandom() {
        Random random = new Random();
        this.elementsHiddenFlag = "abp" + Math.abs(random.nextLong());
        this.sitekeyExtractedFlag = "abp" + Math.abs(random.nextLong());
    }

    private void ensureProvider() {
        if (this.getProvider() == null) {
            AdblockEngine.Builder factory = AdblockEngine.builder((Context)this.getContext(), (String)"adblock");
            this.setProvider((AdblockEngineProvider)new SingleInstanceEngineProvider((AdblockEngine.Factory)factory));
        }
    }

    private void startAbpLoading(String newUrl) {
        String urlWithoutFragment;
        Timber.d((String)"Start loading %s", (Object[])new Object[]{newUrl});
        this.loading = true;
        this.loadError = null;
        if (newUrl != null && this.navigationUrl.compareAndSet(null, urlWithoutFragment = Utils.getUrlWithoutFragment((String)newUrl))) {
            this.generateStylesheetForUrl(urlWithoutFragment, true);
        }
    }

    private void buildInjectJs() {
        try {
            if (this.injectJs == null) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.readScriptFile("inject.js").replace(HIDE_TOKEN, this.readScriptFile("css.js")));
                sb.append(this.readScriptFile("elemhideemu.js"));
                this.injectJs = sb.toString();
            }
            if (this.elemhideBlockedJs == null) {
                this.elemhideBlockedJs = this.readScriptFile("elemhideblocked.js");
            }
        }
        catch (IOException e) {
            Timber.e((Throwable)e, (String)"Failed to read script", (Object[])new Object[0]);
        }
    }

    public void goBack() {
        if (this.loading) {
            this.stopAbpLoading();
        }
        if (this.canGoBack()) {
            this.navigationUrl.set(null);
            this.siteKeyExtractor.startNewPage();
        }
        super.goBack();
    }

    public void goForward() {
        if (this.loading) {
            this.stopAbpLoading();
        }
        if (this.canGoForward()) {
            this.navigationUrl.set(null);
            this.siteKeyExtractor.startNewPage();
        }
        super.goForward();
    }

    public void reload() {
        this.ensureProvider();
        if (this.loading) {
            this.stopAbpLoading();
        }
        super.reload();
    }

    public WebBackForwardList restoreState(Bundle inState) {
        this.siteKeyExtractor.startNewPage();
        return super.restoreState(inState);
    }

    private void loadUrlCommon() {
        this.ensureProvider();
        if (this.loading) {
            this.stopAbpLoading();
        }
        this.siteKeyExtractor.startNewPage();
    }

    public void loadUrl(String url) {
        this.loadUrlCommon();
        super.loadUrl(url);
    }

    public void loadUrl(String url, Map<String, String> additionalHttpHeaders) {
        this.loadUrlCommon();
        super.loadUrl(url, additionalHttpHeaders);
    }

    public void loadData(String data, String mimeType, String encoding) {
        this.loadUrlCommon();
        super.loadData(data, mimeType, encoding);
    }

    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        this.loadUrlCommon();
        super.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
    }

    public void stopLoading() {
        this.stopAbpLoading();
        super.stopLoading();
    }

    private void stopAbpLoading() {
        Timber.d((String)"Stop abp loading", (Object[])new Object[0]);
        this.loading = false;
        this.clearReferrers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generateStylesheetForUrl(String urlWithoutFragment, boolean isMainFrame) {
        boolean isJsInIframesEnabled = this.getJsInIframesEnabled();
        Timber.d((String)"generateStylesheetForUrl() called for url %s, isMainFrame = %b, isJsInIframesEnabled == %b", (Object[])new Object[]{urlWithoutFragment, isMainFrame, isJsInIframesEnabled});
        if (!isMainFrame && !isJsInIframesEnabled) {
            return false;
        }
        String domain = Utils.getDomain((String)urlWithoutFragment);
        if (TextUtils.isEmpty((CharSequence)domain)) {
            Timber.e((String)"Failed to extract domain from %s", (Object[])new Object[]{urlWithoutFragment});
            return false;
        }
        String stylesheetString = EMPTY_ELEMHIDE_STRING;
        String emuSelectorsString = EMPTY_ELEMHIDE_ARRAY_STRING;
        Pair<String, String> stylesheets = this.url2Stylesheets.get(urlWithoutFragment);
        if (stylesheets != null) {
            return !((String)stylesheets.first).equals(EMPTY_ELEMHIDE_STRING) || !((String)stylesheets.second).equals(EMPTY_ELEMHIDE_ARRAY_STRING);
        }
        ReentrantReadWriteLock.ReadLock lock = this.getProvider().getReadEngineLock();
        lock.lock();
        try {
            boolean isDisposed = false;
            if (this.getProvider().getCounter() == 0) {
                isDisposed = true;
            } else {
                lock.unlock();
                this.getProvider().waitForReady();
                lock.lock();
                if (this.getProvider().getCounter() == 0) {
                    isDisposed = true;
                }
            }
            if (!isDisposed && this.getProvider().getEngine() != null) {
                String siteKey;
                FilterEngine filterEngine = this.getProvider().getEngine().getFilterEngine();
                Timber.d((String)"Requesting elemhide selectors from AdblockEngine for %s", (Object[])new Object[]{domain});
                List<Object> referrerChain = isMainFrame ? new ArrayList() : this.buildFramesHierarchy(urlWithoutFragment);
                referrerChain.add(0, urlWithoutFragment);
                SiteKeysConfiguration siteKeysConfiguration = this.getSiteKeysConfiguration();
                String string = siteKey = siteKeysConfiguration != null ? PublicKeyHolderImpl.stripPadding((String)siteKeysConfiguration.getPublicKeyHolder().getAny(referrerChain, EMPTY_ELEMHIDE_STRING)) : null;
                if (!isMainFrame && siteKeysConfiguration != null && siteKey.isEmpty()) {
                    Timber.d((String)"Waiting for a site key when handling %s", (Object[])new Object[]{urlWithoutFragment});
                    boolean waited = this.siteKeyExtractor.waitForSitekeyCheck(urlWithoutFragment, isMainFrame);
                    if (waited) {
                        siteKey = PublicKeyHolderImpl.stripPadding((String)siteKeysConfiguration.getPublicKeyHolder().getAny(referrerChain, EMPTY_ELEMHIDE_STRING));
                    }
                }
                boolean specificOnly = filterEngine.isContentAllowlisted(urlWithoutFragment, FilterEngine.ContentType.maskOf((FilterEngine.ContentType[])new FilterEngine.ContentType[]{FilterEngine.ContentType.GENERICHIDE}), referrerChain, siteKey);
                stylesheetString = this.getProvider().getEngine().getElementHidingStyleSheet(urlWithoutFragment, domain, referrerChain, siteKey, specificOnly);
                Timber.d((String)("Finished requesting elemhide stylesheet, got %d symbols" + (specificOnly ? " (specificOnly)" : EMPTY_ELEMHIDE_STRING) + " for %s"), (Object[])new Object[]{stylesheetString.length(), domain});
                Timber.d((String)"Requesting elemhideemu selectors from AdblockEngine for %s", (Object[])new Object[]{domain});
                List emuSelectors = this.getProvider().getEngine().getElementHidingEmulationSelectors(urlWithoutFragment, domain, referrerChain, siteKey);
                Timber.d((String)"Finished requesting elemhideemu selectors, got %d symbols for %s", (Object[])new Object[]{emuSelectors.size(), domain});
                emuSelectorsString = Utils.emulationSelectorListToJsonArray((List)emuSelectors);
            }
            lock.unlock();
            this.url2Stylesheets.put(urlWithoutFragment, (Pair<String, String>)new Pair((Object)stylesheetString, (Object)emuSelectorsString));
        }
        catch (Throwable throwable) {
            lock.unlock();
            this.url2Stylesheets.put(urlWithoutFragment, (Pair<String, String>)new Pair((Object)stylesheetString, (Object)emuSelectorsString));
            return !stylesheetString.equals(EMPTY_ELEMHIDE_STRING) || !emuSelectorsString.equals(EMPTY_ELEMHIDE_ARRAY_STRING);
        }
        return !stylesheetString.equals(EMPTY_ELEMHIDE_STRING) || !emuSelectorsString.equals(EMPTY_ELEMHIDE_ARRAY_STRING);
    }

    private Pair<String, String> getStylesheetsForUrl(String url) {
        return this.url2Stylesheets.get(Utils.getUrlWithoutFragment((String)url));
    }

    @JavascriptInterface
    public String getElemhideStyleSheet(String url) {
        Pair<String, String> sylesheets = this.getStylesheetsForUrl(url);
        if (sylesheets != null) {
            Timber.d((String)"Elemhide selectors for `%s`, %d bytes", (Object[])new Object[]{url, ((String)sylesheets.first).length()});
            return (String)sylesheets.first;
        }
        return EMPTY_ELEMHIDE_STRING;
    }

    @JavascriptInterface
    public String getElemhideEmulationSelectors(String url) {
        Pair<String, String> sylesheets = this.getStylesheetsForUrl(url);
        if (sylesheets != null) {
            Timber.d((String)"Elemhideemu selectors for `%s`, %d bytes", (Object[])new Object[]{url, ((String)sylesheets.second).length()});
            return (String)sylesheets.second;
        }
        return EMPTY_ELEMHIDE_ARRAY_STRING;
    }

    private void doDispose() {
        Timber.w((String)"Disposing AdblockEngine", (Object[])new Object[0]);
        this.getProvider().release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(Runnable disposeFinished) {
        Timber.d((String)"Dispose invoked", (Object[])new Object[0]);
        if (this.getProvider() == null) {
            Timber.d((String)"No internal AdblockEngineProvider created", (Object[])new Object[0]);
            return;
        }
        ReentrantReadWriteLock.ReadLock lock = this.getProvider().getReadEngineLock();
        lock.lock();
        try {
            AdblockEngine engine = this.getProvider().getEngine();
            if (engine != null) {
                engine.removeSettingsChangedListener(this.engineSettingsChangedCb);
            }
            this.getProvider().removeEngineCreatedListener(this.engineCreatedCb);
            this.getProvider().removeEngineDisposedListener(this.engineDisposedCb);
        }
        finally {
            lock.unlock();
        }
        this.stopLoading();
        DisposeRunnable disposeRunnable = new DisposeRunnable(disposeFinished);
        disposeRunnable.run();
    }

    private class DisposeRunnable
    implements Runnable {
        private final Runnable disposeFinished;

        private DisposeRunnable(Runnable disposeFinished) {
            this.disposeFinished = disposeFinished;
        }

        @Override
        public void run() {
            AdblockWebView.this.doDispose();
            if (this.disposeFinished != null) {
                this.disposeFinished.run();
            }
        }
    }

    private class AdblockWebViewClient
    extends ProxyWebViewClient {
        AdblockWebViewClient(WebViewClient extWebViewClient) {
            super(extWebViewClient);
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            Timber.d((String)"shouldOverrideUrlLoading called for view.getUrl() %s", (Object[])new Object[]{view.getUrl()});
            AdblockWebView.this.clearReferrers();
            return super.shouldOverrideUrlLoading(view, request);
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Timber.d((String)"shouldOverrideUrlLoading called for url %s", (Object[])new Object[]{url});
            AdblockWebView.this.clearReferrers();
            return super.shouldOverrideUrlLoading(view, url);
        }

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            Timber.d((String)"onPageStarted called for url %s", (Object[])new Object[]{url});
            if (AdblockWebView.this.loading) {
                AdblockWebView.this.stopAbpLoading();
            }
            AdblockWebView.this.startAbpLoading(url);
            AdblockWebView.this.notifyNavigation();
            super.onPageStarted(view, url, favicon);
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            Timber.d((String)"onPageFinished called for url %s", (Object[])new Object[]{url});
            AdblockWebView.this.loading = false;
            super.onPageFinished(view, url);
        }

        @Override
        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            Timber.e((String)"onReceivedError: code=%d with description=%s for url=%s", (Object[])new Object[]{errorCode, description, failingUrl});
            AdblockWebView.this.loadError = errorCode;
            super.onReceivedError(view, errorCode, description, failingUrl);
        }

        @Override
        @TargetApi(value=23)
        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            Timber.e((String)"onReceivedError: code=%d with description=%s for url=%s request.isForMainFrame()=%s", (Object[])new Object[]{error.getErrorCode(), error.getDescription(), request.getUrl(), request.isForMainFrame()});
            super.onReceivedError(view, request, error);
        }

        private AbpShouldBlockResult notifyAndReturnBlockingResponse(String requestUrl, List<String> parentFrameUrls, FilterEngine.ContentType contentType) {
            if (AdblockWebView.this.isVisibleResource(contentType)) {
                AdblockWebView.this.elemhideBlockedResource(requestUrl);
            }
            AdblockWebView.this.notifyResourceBlocked(new EventsListener.BlockedResourceInfo(requestUrl, parentFrameUrls, contentType));
            return AbpShouldBlockResult.BLOCK_LOAD;
        }

        private String getFirstParent(List<String> referrerChain) {
            return referrerChain == null || referrerChain.size() == 0 ? AdblockWebView.EMPTY_ELEMHIDE_STRING : referrerChain.get(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AbpShouldBlockResult shouldAbpBlockRequest(WebResourceRequest request) {
            boolean sitekeyCheckEnabled;
            boolean canContainSitekey;
            boolean isAllowlisted;
            boolean isMainFrame;
            block41: {
                String url = request.getUrl().toString();
                String urlWithoutFragment = Utils.getUrlWithoutFragment((String)url);
                isMainFrame = request.isForMainFrame();
                isAllowlisted = false;
                canContainSitekey = false;
                String referrer = (String)request.getRequestHeaders().get("Referer");
                ReentrantReadWriteLock.ReadLock lock = AdblockWebView.this.getProvider().getReadEngineLock();
                lock.lock();
                try {
                    boolean isDisposed = false;
                    if (AdblockWebView.this.getProvider().getCounter() == 0) {
                        isDisposed = true;
                    } else {
                        lock.unlock();
                        AdblockWebView.this.getProvider().waitForReady();
                        lock.lock();
                        if (AdblockWebView.this.getProvider().getCounter() == 0) {
                            isDisposed = true;
                        }
                    }
                    AdblockEngine engine = AdblockWebView.this.getProvider().getEngine();
                    if (isDisposed || engine == null) {
                        Timber.e((String)"FilterEngine already disposed", (Object[])new Object[0]);
                        AbpShouldBlockResult abpShouldBlockResult = AbpShouldBlockResult.NOT_ENABLED;
                        return abpShouldBlockResult;
                    }
                    if (AdblockWebView.this.adblockEnabled.get() == OptionalBoolean.UNDEFINED) {
                        Timber.e((String)"No adblockEnabled value", (Object[])new Object[0]);
                        AbpShouldBlockResult abpShouldBlockResult = AbpShouldBlockResult.NOT_ENABLED;
                        return abpShouldBlockResult;
                    }
                    OptionalBoolean newValue = OptionalBoolean.from(engine.isEnabled());
                    AdblockWebView.this.adblockEnabled.set(newValue);
                    if (newValue == OptionalBoolean.FALSE) {
                        Timber.d((String)"adblockEnabled = false", (Object[])new Object[0]);
                        AbpShouldBlockResult abpShouldBlockResult = AbpShouldBlockResult.NOT_ENABLED;
                        return abpShouldBlockResult;
                    }
                    Timber.d((String)"Loading url %s", (Object[])new Object[]{url});
                    if (referrer != null) {
                        Timber.d((String)"Header referrer for %s is %s", (Object[])new Object[]{url, referrer});
                        if (!url.equals(referrer)) {
                            AdblockWebView.this.url2Referrer.put(urlWithoutFragment, referrer);
                        } else {
                            Timber.w((String)"Header referrer value is the same as url, skipping url2Referrer.put()", (Object[])new Object[0]);
                        }
                    } else {
                        Timber.w((String)"No referrer header for %s", (Object[])new Object[]{url});
                    }
                    boolean bl = sitekeyCheckEnabled = engine.isAcceptableAdsEnabled() || AdblockWebView.this.getJsInIframesEnabled();
                    if (!sitekeyCheckEnabled) {
                        // empty if block
                    }
                    if (isMainFrame) {
                        Timber.w((String)"%s is main frame, allow loading", (Object[])new Object[]{url});
                        AdblockWebView.this.siteKeyExtractor.setEnabled(sitekeyCheckEnabled);
                        AdblockWebView.this.clearStylesheets();
                        AdblockWebView.this.generateStylesheetForUrl(urlWithoutFragment, true);
                        break block41;
                    }
                    List referrerChain = AdblockWebView.this.buildFramesHierarchy(urlWithoutFragment);
                    SiteKeysConfiguration siteKeysConfiguration = AdblockWebView.this.getSiteKeysConfiguration();
                    String siteKey = siteKeysConfiguration != null ? PublicKeyHolderImpl.stripPadding((String)siteKeysConfiguration.getPublicKeyHolder().getAny(referrerChain, AdblockWebView.EMPTY_ELEMHIDE_STRING)) : null;
                    FilterEngine.ContentType contentType = AdblockWebView.this.ensureContentTypeDetectorCreatedAndGet().detect(request);
                    if (contentType == null) {
                        Timber.w((String)"contentTypeDetector didn't recognize content type", (Object[])new Object[0]);
                        contentType = FilterEngine.ContentType.OTHER;
                    }
                    if (contentType == FilterEngine.ContentType.SUBDOCUMENT && referrer != null) {
                        try {
                            AdblockWebView.this.url2Referrer.put(Utils.getOrigin((String)url), referrer);
                        }
                        catch (IllegalArgumentException | MalformedURLException e) {
                            Timber.e((Throwable)e, (String)"Failed to extract origin from %s", (Object[])new Object[]{url});
                        }
                    }
                    if (engine.isContentAllowlisted(url, FilterEngine.ContentType.maskOf((FilterEngine.ContentType[])new FilterEngine.ContentType[]{FilterEngine.ContentType.DOCUMENT}), referrerChain, siteKey)) {
                        isAllowlisted = true;
                        Timber.w((String)"%s document is allowlisted, allow loading", (Object[])new Object[]{url});
                        AdblockWebView.this.notifyResourceAllowlisted(new EventsListener.AllowlistedResourceInfo(url, referrerChain, EventsListener.AllowlistReason.DOCUMENT));
                    } else {
                        AdblockEngine.MatchesResult result;
                        boolean specificOnly;
                        if (contentType == FilterEngine.ContentType.SUBDOCUMENT || contentType == FilterEngine.ContentType.OTHER) {
                            canContainSitekey = true;
                        }
                        if (specificOnly = engine.isContentAllowlisted(url, FilterEngine.ContentType.maskOf((FilterEngine.ContentType[])new FilterEngine.ContentType[]{FilterEngine.ContentType.GENERICBLOCK}), referrerChain, siteKey)) {
                            Timber.w((String)"Found genericblock filter for url %s", (Object[])new Object[]{url});
                        }
                        AdblockEngine.MatchesResult matchesResult = result = engine.isContentAllowlisted(url, FilterEngine.ContentType.maskOf((FilterEngine.ContentType[])new FilterEngine.ContentType[]{contentType}), referrerChain, siteKey) ? AdblockEngine.MatchesResult.ALLOWLISTED : engine.matches(url, FilterEngine.ContentType.maskOf((FilterEngine.ContentType[])new FilterEngine.ContentType[]{contentType}), this.getFirstParent(referrerChain), siteKey, specificOnly);
                        if (result == AdblockEngine.MatchesResult.BLOCKED) {
                            Timber.i((String)"Attempting to block request with AA on the first try: %s", (Object[])new Object[]{url});
                            boolean waitedForSitekey = AdblockWebView.this.siteKeyExtractor.waitForSitekeyCheck(url, isMainFrame);
                            if (waitedForSitekey) {
                                Timber.i((String)"Restarting the check having waited for the sitekey: %s", (Object[])new Object[]{url});
                                String string = siteKey = siteKeysConfiguration != null ? PublicKeyHolderImpl.stripPadding((String)siteKeysConfiguration.getPublicKeyHolder().getAny(referrerChain, AdblockWebView.EMPTY_ELEMHIDE_STRING)) : null;
                                if (siteKey == null || siteKey.isEmpty()) {
                                    Timber.i((String)"SiteKey is not found, blocking the resource %s", (Object[])new Object[]{url});
                                    AbpShouldBlockResult abpShouldBlockResult = this.notifyAndReturnBlockingResponse(url, referrerChain, contentType);
                                    return abpShouldBlockResult;
                                }
                                if (engine.isContentAllowlisted(url, FilterEngine.ContentType.maskOf((FilterEngine.ContentType[])new FilterEngine.ContentType[]{FilterEngine.ContentType.DOCUMENT}), referrerChain, siteKey)) {
                                    isAllowlisted = true;
                                    Timber.w((String)"%s document is allowlisted, allow loading", (Object[])new Object[]{url});
                                    AdblockWebView.this.notifyResourceAllowlisted(new EventsListener.AllowlistedResourceInfo(url, referrerChain, EventsListener.AllowlistReason.DOCUMENT));
                                } else {
                                    specificOnly = engine.isContentAllowlisted(url, FilterEngine.ContentType.maskOf((FilterEngine.ContentType[])new FilterEngine.ContentType[]{FilterEngine.ContentType.GENERICBLOCK}), referrerChain, siteKey);
                                    if (specificOnly) {
                                        Timber.w((String)"Found genericblock filter for url %s", (Object[])new Object[]{url});
                                    }
                                    AdblockEngine.MatchesResult matchesResult2 = result = engine.isContentAllowlisted(url, FilterEngine.ContentType.maskOf((FilterEngine.ContentType[])new FilterEngine.ContentType[]{contentType}), referrerChain, siteKey) ? AdblockEngine.MatchesResult.ALLOWLISTED : engine.matches(url, FilterEngine.ContentType.maskOf((FilterEngine.ContentType[])new FilterEngine.ContentType[]{contentType}), this.getFirstParent(referrerChain), siteKey, specificOnly);
                                    if (result == AdblockEngine.MatchesResult.BLOCKED) {
                                        Timber.i((String)"Blocked loading %s with sitekeyCheckEnabled %s", (Object[])new Object[]{url, sitekeyCheckEnabled ? "enabled" : "disabled"});
                                        AbpShouldBlockResult abpShouldBlockResult = this.notifyAndReturnBlockingResponse(url, referrerChain, contentType);
                                        return abpShouldBlockResult;
                                    }
                                    if (result == AdblockEngine.MatchesResult.ALLOWLISTED) {
                                        isAllowlisted = true;
                                        Timber.w((String)"%s is allowlisted in matches()", (Object[])new Object[]{url});
                                        AdblockWebView.this.notifyResourceAllowlisted(new EventsListener.AllowlistedResourceInfo(url, referrerChain, EventsListener.AllowlistReason.FILTER));
                                    }
                                    Timber.d((String)"Allowed loading %s", (Object[])new Object[]{url});
                                }
                            }
                            if (!isAllowlisted) {
                                Timber.i((String)"Blocked loading %s with sitekeyCheckEnabled %s", (Object[])new Object[]{url, sitekeyCheckEnabled ? "enabled" : "disabled"});
                                AbpShouldBlockResult abpShouldBlockResult = this.notifyAndReturnBlockingResponse(url, referrerChain, contentType);
                                return abpShouldBlockResult;
                            }
                        } else if (result == AdblockEngine.MatchesResult.ALLOWLISTED) {
                            isAllowlisted = true;
                            Timber.w((String)"%s is allowlisted in matches()", (Object[])new Object[]{url});
                            AdblockWebView.this.notifyResourceAllowlisted(new EventsListener.AllowlistedResourceInfo(url, referrerChain, EventsListener.AllowlistReason.FILTER));
                        }
                        Timber.d((String)"Allowed loading %s", (Object[])new Object[]{url});
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            SiteKeysConfiguration siteKeysConfiguration = AdblockWebView.this.getSiteKeysConfiguration();
            if ((sitekeyCheckEnabled || siteKeysConfiguration != null && siteKeysConfiguration.getForceChecks()) && (isMainFrame || canContainSitekey && !isAllowlisted)) {
                return AbpShouldBlockResult.ALLOW_LOAD;
            }
            return AbpShouldBlockResult.ALLOW_LOAD_NO_SITEKEY_CHECK;
        }

        @Override
        @TargetApi(value=21)
        public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
            WebResourceResponse externalResponse;
            AbpShouldBlockResult abpBlockResult;
            if (request.isForMainFrame()) {
                Timber.d((String)"Updating navigationUrl to `%s`", (Object[])new Object[]{request.getUrl().toString()});
                AdblockWebView.this.navigationUrl.set(Utils.getUrlWithoutFragment((String)request.getUrl().toString()));
            }
            if (AbpShouldBlockResult.NOT_ENABLED.equals((Object)(abpBlockResult = this.shouldAbpBlockRequest(request)))) {
                AdblockWebView.this.clearStylesheets();
                return WebResponseResult.ALLOW_LOAD;
            }
            if (AbpShouldBlockResult.BLOCK_LOAD.equals((Object)abpBlockResult)) {
                return WebResponseResult.BLOCK_LOAD;
            }
            Map requestHeaders = request.getRequestHeaders();
            String url = request.getUrl().toString();
            WebViewClient extWebViewClient = this.getExtWebViewClient();
            if (extWebViewClient != null && (externalResponse = extWebViewClient.shouldInterceptRequest(view, request)) != null) {
                if (!AbpShouldBlockResult.ALLOW_LOAD_NO_SITEKEY_CHECK.equals((Object)abpBlockResult)) {
                    Timber.d((String)"Verifying site keys with external shouldInterceptRequest response", (Object[])new Object[0]);
                    AdblockWebView.this.getSiteKeysConfiguration().getSiteKeyVerifier().verifyInHeaders(url, requestHeaders, externalResponse.getResponseHeaders());
                    Timber.d((String)"Finished verifying, returning external response and stop", (Object[])new Object[0]);
                } else {
                    Timber.d((String)"Skipped verifying of the site keys with external shouldInterceptRequest response", (Object[])new Object[0]);
                }
                return externalResponse;
            }
            if (AbpShouldBlockResult.ALLOW_LOAD_NO_SITEKEY_CHECK.equals((Object)abpBlockResult)) {
                return WebResponseResult.ALLOW_LOAD;
            }
            if (requestHeaders.containsKey("Range")) {
                Timber.d((String)"Skipping site key check for the request with a Range header", (Object[])new Object[0]);
                return WebResponseResult.ALLOW_LOAD;
            }
            return AdblockWebView.this.siteKeyExtractor.extract(request);
        }
    }

    public static class WebResponseResult {
        public static final String RESPONSE_CHARSET_NAME = "UTF-8";
        public static final String RESPONSE_MIME_TYPE = "text/plain";
        public static final WebResourceResponse ALLOW_LOAD = null;
        public static final WebResourceResponse BLOCK_LOAD = new WebResourceResponse("text/plain", "UTF-8", null);
    }

    private static enum AbpShouldBlockResult {
        NOT_ENABLED,
        ALLOW_LOAD,
        ALLOW_LOAD_NO_SITEKEY_CHECK,
        BLOCK_LOAD;

    }

    private class AdblockWebWebChromeClient
    extends ProxyWebChromeClient {
        AdblockWebWebChromeClient(WebChromeClient extWebChromeClient) {
            super(extWebChromeClient);
        }

        @Override
        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            Timber.d((String)"JS: level=%s, message=\"%s\", sourceId=\"%s\", line=%d", (Object[])new Object[]{consoleMessage.messageLevel(), consoleMessage.message(), consoleMessage.sourceId(), consoleMessage.lineNumber()});
            return super.onConsoleMessage(consoleMessage);
        }

        @Override
        public void onProgressChanged(WebView view, int newProgress) {
            Timber.d((String)"onProgressChanged to %d%% for url: %s", (Object[])new Object[]{newProgress, view.getUrl()});
            AdblockWebView.this.tryInjectJs();
            super.onProgressChanged(view, newProgress);
        }
    }

    public static interface EventsListener {
        public void onNavigation();

        public void onResourceLoadingBlocked(BlockedResourceInfo var1);

        public void onResourceLoadingAllowlisted(AllowlistedResourceInfo var1);

        public static final class AllowlistedResourceInfo
        extends ResourceInfo {
            private final AllowlistReason reason;

            public AllowlistedResourceInfo(String requestUrl, List<String> parentFrameUrls, AllowlistReason reasons) {
                super(requestUrl, parentFrameUrls);
                this.reason = reasons;
            }

            public AllowlistReason getReason() {
                return this.reason;
            }
        }

        public static enum AllowlistReason {
            DOCUMENT,
            DOMAIN,
            FILTER;

        }

        public static final class BlockedResourceInfo
        extends ResourceInfo {
            private final FilterEngine.ContentType contentType;

            BlockedResourceInfo(String requestUrl, List<String> parentFrameUrls, FilterEngine.ContentType contentType) {
                super(requestUrl, parentFrameUrls);
                this.contentType = contentType;
            }

            public FilterEngine.ContentType getContentType() {
                return this.contentType;
            }
        }

        public static class ResourceInfo {
            private final String requestUrl;
            private final List<String> parentFrameUrls;

            ResourceInfo(String requestUrl, List<String> parentFrameUrls) {
                this.requestUrl = requestUrl;
                this.parentFrameUrls = new ArrayList<String>(parentFrameUrls);
            }

            public String getRequestUrl() {
                return this.requestUrl;
            }

            public List<String> getParentFrameUrls() {
                return this.parentFrameUrls;
            }
        }
    }

    public static enum OptionalBoolean {
        UNDEFINED,
        TRUE,
        FALSE;


        public static OptionalBoolean from(boolean value) {
            return value ? TRUE : FALSE;
        }
    }
}

