/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus.android.webview;

import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import org.adblockplus.libadblockplus.android.webview.AdblockWebView;
import org.adblockplus.libadblockplus.android.webview.HttpHeaderSiteKeyExtractor;
import org.adblockplus.libadblockplus.android.webview.JsSiteKeyExtractor;
import org.adblockplus.libadblockplus.android.webview.SiteKeyExtractor;
import org.adblockplus.libadblockplus.sitekey.SiteKeysConfiguration;
import timber.log.Timber;

public class CombinedSiteKeyExtractor
implements SiteKeyExtractor {
    private final SiteKeyExtractor httpExtractor;
    private final SiteKeyExtractor jsExtractor;

    protected CombinedSiteKeyExtractor(AdblockWebView webView) {
        this.httpExtractor = new HttpHeaderSiteKeyExtractor(webView);
        this.jsExtractor = new JsSiteKeyExtractor(webView);
    }

    @Override
    public WebResourceResponse extract(WebResourceRequest frameRequest) {
        if (!frameRequest.isForMainFrame()) {
            Timber.d((String)"Falling back to native sitekey requests for %s", (Object[])new Object[]{frameRequest.getUrl().toString()});
            return this.httpExtractor.extract(frameRequest);
        }
        return AdblockWebView.WebResponseResult.ALLOW_LOAD;
    }

    @Override
    public void setSiteKeysConfiguration(SiteKeysConfiguration siteKeysConfiguration) {
        this.httpExtractor.setSiteKeysConfiguration(siteKeysConfiguration);
        this.jsExtractor.setSiteKeysConfiguration(siteKeysConfiguration);
    }

    @Override
    public void startNewPage() {
        this.httpExtractor.startNewPage();
        this.jsExtractor.startNewPage();
    }

    @Override
    public boolean waitForSitekeyCheck(String url, boolean isMainFrame) {
        boolean httpWaited = this.httpExtractor.waitForSitekeyCheck(url, isMainFrame);
        boolean jsWaited = this.jsExtractor.waitForSitekeyCheck(url, isMainFrame);
        return httpWaited || jsWaited;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.httpExtractor.setEnabled(enabled);
        this.jsExtractor.setEnabled(enabled);
    }
}

