/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus.android.webview.content_type;

import android.webkit.WebResourceRequest;
import java.util.Map;
import org.adblockplus.libadblockplus.FilterEngine;
import org.adblockplus.libadblockplus.android.webview.content_type.ContentTypeDetector;
import timber.log.Timber;

public class HeadersContentTypeDetector
implements ContentTypeDetector {
    @Override
    public FilterEngine.ContentType detect(WebResourceRequest request) {
        boolean isXmlHttpRequest;
        Map headers = request.getRequestHeaders();
        boolean bl = isXmlHttpRequest = headers.containsKey("X-Requested-With") && "XMLHttpRequest".equals(headers.get("X-Requested-With"));
        if (isXmlHttpRequest) {
            Timber.w((String)"using xmlhttprequest content type", (Object[])new Object[0]);
            return FilterEngine.ContentType.XMLHTTPREQUEST;
        }
        String acceptType = (String)headers.get("Accept");
        if (acceptType != null && acceptType.contains("text/html")) {
            Timber.w((String)"using subdocument content type", (Object[])new Object[0]);
            return FilterEngine.ContentType.SUBDOCUMENT;
        }
        return null;
    }
}

