/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus.android.webview;

import android.os.Handler;
import android.webkit.JavascriptInterface;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.adblockplus.libadblockplus.android.Utils;
import org.adblockplus.libadblockplus.android.webview.AdblockWebView;
import org.adblockplus.libadblockplus.android.webview.BaseSiteKeyExtractor;
import org.adblockplus.libadblockplus.sitekey.SiteKeyException;
import org.adblockplus.libadblockplus.sitekey.SiteKeyVerifier;
import timber.log.Timber;

class JsSiteKeyExtractor
extends BaseSiteKeyExtractor {
    private volatile CountDownLatch latch;
    private final AtomicBoolean isSiteKeyProcessingFinished;
    private final AtomicBoolean isJavascriptInterfaceSet;
    private final Handler callerThreadHandler = new Handler();
    private Runnable enableStateRunner;
    private Runnable disableStateRunner;

    JsSiteKeyExtractor(AdblockWebView view) {
        super(view);
        view.addJavascriptInterface(new JsCallbackInterface(this), "AbpCallback");
        this.isJavascriptInterfaceSet = new AtomicBoolean(true);
        this.isSiteKeyProcessingFinished = new AtomicBoolean(false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        final AdblockWebView webView = (AdblockWebView)((Object)this.webViewWeakReference.get());
        if (webView == null) {
            return;
        }
        if (enabled) {
            if (!this.isJavascriptInterfaceSet.get()) {
                if (this.enableStateRunner == null) {
                    this.enableStateRunner = new Runnable(){

                        @Override
                        public void run() {
                            webView.addJavascriptInterface(new JsCallbackInterface(JsSiteKeyExtractor.this), "AbpCallback");
                            JsSiteKeyExtractor.this.isJavascriptInterfaceSet.set(true);
                        }
                    };
                }
                Timber.d((String)"Enabling JsSiteKeyExtractor", (Object[])new Object[0]);
                this.callerThreadHandler.post(this.enableStateRunner);
            }
        } else {
            if (this.disableStateRunner == null) {
                this.disableStateRunner = new Runnable(){

                    @Override
                    public void run() {
                        webView.removeJavascriptInterface("AbpCallback");
                        JsSiteKeyExtractor.this.isJavascriptInterfaceSet.set(false);
                    }
                };
            }
            Timber.d((String)"Disabling JsSiteKeyExtractor", (Object[])new Object[0]);
            this.callerThreadHandler.post(this.disableStateRunner);
            if (this.latch != null) {
                this.latch.countDown();
                this.latch = null;
            }
        }
    }

    @Override
    public WebResourceResponse extract(WebResourceRequest request) {
        return null;
    }

    @Override
    public void startNewPage() {
        Timber.d((String)"startNewPage() called", (Object[])new Object[0]);
        this.isSiteKeyProcessingFinished.set(false);
        this.latch = new CountDownLatch(1);
    }

    @Override
    public boolean waitForSitekeyCheck(String url, boolean isMainFrame) {
        if (isMainFrame) {
            return false;
        }
        if (!this.isEnabled() || this.isSiteKeyProcessingFinished.get()) {
            return false;
        }
        CountDownLatch countDownLatch = this.latch;
        if (countDownLatch == null) {
            Timber.w((String)"waitForSitekeyCheck() called for `%s` with `latch == null`!", (Object[])new Object[]{url});
            return false;
        }
        Timber.d((String)"Holding request %s", (Object[])new Object[]{url});
        try {
            countDownLatch.await(1000L, TimeUnit.MILLISECONDS);
            Timber.d((String)"Un-holding request %s", (Object[])new Object[]{url});
        }
        catch (InterruptedException error) {
            Timber.e((String)"Holding request error: %s", (Object[])new Object[]{error});
        }
        return true;
    }

    private void verifySiteKey(String url, String userAgent, String value) {
        try {
            SiteKeyVerifier verifier = this.getSiteKeysConfiguration().getSiteKeyVerifier();
            if (verifier == null) {
                throw new AssertionError((Object)"Verifier must be set before this is called");
            }
            if (verifier.verify(Utils.getUrlWithoutFragment((String)url), userAgent, value)) {
                Timber.d((String)"Url %s public key verified successfully", (Object[])new Object[]{url});
            } else {
                Timber.e((String)"Url %s public key is not verified", (Object[])new Object[]{url});
            }
        }
        catch (SiteKeyException e) {
            Timber.e((Throwable)e, (String)"Failed to verify sitekey header", (Object[])new Object[0]);
        }
    }

    public static class JsCallbackInterface {
        static final String NAME = "AbpCallback";
        private final WeakReference<JsSiteKeyExtractor> extractorRef;
        private final WeakReference<AdblockWebView> webViewRef;

        private JsCallbackInterface(JsSiteKeyExtractor extractor) {
            this.extractorRef = new WeakReference<JsSiteKeyExtractor>(extractor);
            this.webViewRef = extractor.webViewWeakReference;
        }

        private JsSiteKeyExtractor getExtractorIfStillExist() {
            JsSiteKeyExtractor extractor = (JsSiteKeyExtractor)this.extractorRef.get();
            if (extractor != null) {
                return extractor;
            }
            AdblockWebView webView = (AdblockWebView)((Object)this.webViewRef.get());
            if (webView != null) {
                webView.removeJavascriptInterface(NAME);
            }
            return null;
        }

        @JavascriptInterface
        public void onSiteKeyExtracted(String key, String url, String userAgent) {
            CountDownLatch countDownLatch;
            Timber.d((String)"Received sitekey for \nurl: %s", (Object[])new Object[]{url});
            JsSiteKeyExtractor extractor = this.getExtractorIfStillExist();
            if (extractor == null || !extractor.isEnabled()) {
                return;
            }
            if (key != null && !key.isEmpty()) {
                extractor.verifySiteKey(url, userAgent, key);
            }
            if ((countDownLatch = extractor.latch) != null) {
                countDownLatch.countDown();
            }
            extractor.isSiteKeyProcessingFinished.set(true);
        }

        @JavascriptInterface
        public void onSiteKeyDoesNotExist(String url) {
            JsSiteKeyExtractor extractor = this.getExtractorIfStillExist();
            if (extractor == null || !extractor.isEnabled()) {
                return;
            }
            CountDownLatch countDownLatch = extractor.latch;
            if (countDownLatch != null) {
                countDownLatch.countDown();
            }
            extractor.isSiteKeyProcessingFinished.set(true);
            Timber.d((String)"Key does not exist on url %s", (Object[])new Object[]{url});
        }

        @JavascriptInterface
        public void onDomNotReady(String url) {
            JsSiteKeyExtractor extractor = this.getExtractorIfStillExist();
            if (extractor == null || !extractor.isEnabled()) {
                return;
            }
            extractor.isSiteKeyProcessingFinished.set(false);
            Timber.d((String)"DOM not yet ready on url %s", (Object[])new Object[]{url});
        }
    }
}

