/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus.android.webview;

import android.os.Handler;
import android.os.Looper;
import java.lang.ref.WeakReference;
import org.adblockplus.libadblockplus.android.webview.AdblockWebView;

public final class WebViewCounters {
    private int blockedCounter = 0;
    private int allowlistedCounter = 0;
    private EventsListener eventsListener;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final Runnable blockedResetRunnable = new WeakRunnable(this, new ResetBlockedOperation());
    private final Runnable blockedIncrementRunnable = new WeakRunnable(this, new IncrementBlockedOperation());
    private final Runnable allowlistedResetRunnable = new WeakRunnable(this, new ResetAllowlistedOperation());
    private final Runnable allowlistedIncrementRunnable = new WeakRunnable(this, new IncrementAllowlistedOperation());

    public static AdblockWebView.EventsListener bindAdblockWebView(EventsListener eventsListener) {
        WebViewCounters counters = new WebViewCounters(eventsListener);
        return new AdblockWebView.EventsListener(){

            @Override
            public void onNavigation() {
                WebViewCounters.this.resetBlocked();
                WebViewCounters.this.resetAllowlisted();
            }

            @Override
            public void onResourceLoadingBlocked(AdblockWebView.EventsListener.BlockedResourceInfo info) {
                WebViewCounters.this.incrementBlocked();
            }

            @Override
            public void onResourceLoadingAllowlisted(AdblockWebView.EventsListener.AllowlistedResourceInfo info) {
                WebViewCounters.this.incrementAllowlisted();
            }
        };
    }

    public WebViewCounters(EventsListener eventsListener) {
        this.eventsListener = eventsListener;
    }

    public void resetBlocked() {
        this.handler.post(this.blockedResetRunnable);
    }

    public void resetAllowlisted() {
        this.handler.post(this.allowlistedResetRunnable);
    }

    public void incrementBlocked() {
        this.handler.post(this.blockedIncrementRunnable);
    }

    public void incrementAllowlisted() {
        this.handler.post(this.allowlistedIncrementRunnable);
    }

    private void notifyBlockedChanged() {
        if (this.eventsListener != null) {
            this.eventsListener.onBlockedChanged(this.blockedCounter);
        }
    }

    private void notifyAllowlistedChanged() {
        if (this.eventsListener != null) {
            this.eventsListener.onAllowlistedChanged(this.allowlistedCounter);
        }
    }

    public static interface EventsListener {
        public void onBlockedChanged(int var1);

        public void onAllowlistedChanged(int var1);
    }

    private static final class WeakRunnable
    implements Runnable {
        private WeakReference<WebViewCounters> weakCounters;
        private Operation operation;

        WeakRunnable(WebViewCounters counters, Operation operation) {
            this.weakCounters = new WeakReference<WebViewCounters>(counters);
            this.operation = operation;
        }

        @Override
        public void run() {
            WebViewCounters counters = (WebViewCounters)this.weakCounters.get();
            if (counters != null) {
                this.operation.run(counters);
            }
        }

        static interface Operation {
            public void run(WebViewCounters var1);
        }
    }

    private static class ResetBlockedOperation
    implements WeakRunnable.Operation {
        private ResetBlockedOperation() {
        }

        @Override
        public void run(WebViewCounters counters) {
            counters.blockedCounter = 0;
            counters.notifyBlockedChanged();
        }
    }

    private static class IncrementBlockedOperation
    implements WeakRunnable.Operation {
        private IncrementBlockedOperation() {
        }

        @Override
        public void run(WebViewCounters counters) {
            ++counters.blockedCounter;
            counters.notifyBlockedChanged();
        }
    }

    private static class ResetAllowlistedOperation
    implements WeakRunnable.Operation {
        private ResetAllowlistedOperation() {
        }

        @Override
        public void run(WebViewCounters counters) {
            counters.allowlistedCounter = 0;
            counters.notifyAllowlistedChanged();
        }
    }

    private static class IncrementAllowlistedOperation
    implements WeakRunnable.Operation {
        private IncrementAllowlistedOperation() {
        }

        @Override
        public void run(WebViewCounters counters) {
            ++counters.allowlistedCounter;
            counters.notifyAllowlistedChanged();
        }
    }
}

