/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus.android.webview.content_type;

import android.webkit.WebResourceRequest;
import java.util.HashMap;
import java.util.Map;
import org.adblockplus.libadblockplus.FilterEngine;
import org.adblockplus.libadblockplus.android.webview.content_type.ContentTypeDetector;

public class UrlFileExtensionTypeDetector
implements ContentTypeDetector {
    private static final String[] EXTENSIONS_JS = new String[]{"js"};
    private static final String[] EXTENSIONS_CSS = new String[]{"css"};
    private static final String[] EXTENSIONS_FONT = new String[]{"ttf", "woff", "woff2"};
    private static final String[] EXTENSIONS_HTML = new String[]{"htm", "html"};
    private static final String[] EXTENSIONS_IMAGE = new String[]{"gif", "png", "jpg", "jpe", "jpeg", "bmp", "apng", "cur", "jfif", "ico", "pjpeg", "pjp", "svg", "tif", "tiff", "webp"};
    private static final String[] EXTENSIONS_MEDIA = new String[]{"webm", "mkv", "flv", "vob", "ogv", "drc", "mng", "avi", "mov", "gifv", "qt", "wmv", "yuv", "rm", "rmvb", "asf", "amv", "mp4", "m4p", "mp2", "mpe", "mpv", "mpg", "mpeg", "m2v", "m4v", "svi", "3gp", "3g2", "mxf", "roq", "nsv", "8svx", "aa", "aac", "aax", "act", "aiff", "alac", "amr", "ape", "au", "awb", "cda", "dct", "dss", "dvf", "flac", "gsm", "iklax", "ivs", "m4a", "m4b", "mmf", "mogg", "mp3", "mpc", "msv", "nmf", "oga", "ogg", "opus", "ra", "raw", "rf64", "sln", "tta", "voc", "vox", "wav", "wma", "wv"};
    private static final Map<String, FilterEngine.ContentType> extensionTypeMap = new HashMap<String, FilterEngine.ContentType>();

    private static void mapExtensions(String[] extensions, FilterEngine.ContentType contentType) {
        for (String extension : extensions) {
            extensionTypeMap.put(extension.toLowerCase(), contentType);
        }
    }

    @Override
    public FilterEngine.ContentType detect(WebResourceRequest request) {
        if (request == null || request.getUrl() == null) {
            return null;
        }
        String path = request.getUrl().getPath();
        if (path == null) {
            return null;
        }
        int lastIndexOfDot = path.lastIndexOf(46);
        if (lastIndexOfDot == -1) {
            return null;
        }
        String fileExtension = path.substring(lastIndexOfDot + 1);
        if (fileExtension != null) {
            return extensionTypeMap.get(fileExtension.toLowerCase());
        }
        return null;
    }

    static {
        UrlFileExtensionTypeDetector.mapExtensions(EXTENSIONS_JS, FilterEngine.ContentType.SCRIPT);
        UrlFileExtensionTypeDetector.mapExtensions(EXTENSIONS_CSS, FilterEngine.ContentType.STYLESHEET);
        UrlFileExtensionTypeDetector.mapExtensions(EXTENSIONS_FONT, FilterEngine.ContentType.FONT);
        UrlFileExtensionTypeDetector.mapExtensions(EXTENSIONS_HTML, FilterEngine.ContentType.SUBDOCUMENT);
        UrlFileExtensionTypeDetector.mapExtensions(EXTENSIONS_IMAGE, FilterEngine.ContentType.IMAGE);
        UrlFileExtensionTypeDetector.mapExtensions(EXTENSIONS_MEDIA, FilterEngine.ContentType.MEDIA);
    }
}

