/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.adblockplus.libadblockplus.Filter;
import org.adblockplus.libadblockplus.FilterChangeCallback;
import org.adblockplus.libadblockplus.JsValue;
import org.adblockplus.libadblockplus.Subscription;

public final class FilterEngine {
    public static final String EMPTY_PARENT = "";
    public static final String EMPTY_SITEKEY = "";
    protected final long ptr;

    FilterEngine(long jniPlatformPtr) {
        this.ptr = jniPlatformPtr;
    }

    private static native void addFilter(long var0, String var2);

    private static native void removeFilter(long var0, String var2);

    public Filter getFilter(String text) {
        Filter filter = FilterEngine.getFilter(this.ptr, text);
        if (filter != null) {
            filter.setFilterEngine(this);
        }
        return filter;
    }

    public List<Filter> getListedFilters() {
        List<Filter> filterList = FilterEngine.getListedFilters(this.ptr);
        for (Filter filter : filterList) {
            filter.setFilterEngine(this);
        }
        return filterList;
    }

    public Subscription getSubscription(String url) {
        return FilterEngine.getSubscription(this.ptr, url, this);
    }

    public List<Subscription> getListedSubscriptions() {
        return FilterEngine.getListedSubscriptions(this.ptr, this);
    }

    public List<Subscription> fetchAvailableSubscriptions() {
        return FilterEngine.fetchAvailableSubscriptions(this.ptr, this);
    }

    public void removeFilterChangeCallback() {
        FilterEngine.removeFilterChangeCallback(this.ptr);
    }

    public void setFilterChangeCallback(FilterChangeCallback callback) {
        FilterEngine.setFilterChangeCallback(this.ptr, callback.ptr);
    }

    public String getElementHidingStyleSheet(String domain) {
        return this.getElementHidingStyleSheet(domain, false);
    }

    public String getElementHidingStyleSheet(String domain, boolean specificOnly) {
        return FilterEngine.getElementHidingStyleSheet(this.ptr, domain, specificOnly);
    }

    public List<EmulationSelector> getElementHidingEmulationSelectors(String domain) {
        return FilterEngine.getElementHidingEmulationSelectors(this.ptr, domain);
    }

    @Deprecated
    public Filter matches(String url, Set<ContentType> contentTypes, List<String> documentUrls, String siteKey) {
        Filter filter = FilterEngine.matches(this.ptr, url, contentTypes.toArray(new ContentType[contentTypes.size()]), documentUrls, siteKey, false);
        if (filter != null) {
            filter.setFilterEngine(this);
        }
        return filter;
    }

    @Deprecated
    public Filter matches(String url, Set<ContentType> contentTypes, List<String> documentUrls, String siteKey, boolean specificOnly) {
        Filter filter = FilterEngine.matches(this.ptr, url, contentTypes.toArray(new ContentType[contentTypes.size()]), documentUrls, siteKey, specificOnly);
        if (filter != null) {
            filter.setFilterEngine(this);
        }
        return filter;
    }

    public Filter matches(String url, Set<ContentType> contentTypes, String parent, String siteKey, boolean specificOnly) {
        Filter filter = FilterEngine.matches(this.ptr, url, contentTypes.toArray(new ContentType[contentTypes.size()]), parent, siteKey, specificOnly);
        if (filter != null) {
            filter.setFilterEngine(this);
        }
        return filter;
    }

    public boolean isContentAllowlisted(String url, Set<ContentType> contentTypes, List<String> documentUrls, String siteKey) {
        return FilterEngine.isContentAllowlisted(this.ptr, url, contentTypes.toArray(new ContentType[contentTypes.size()]), documentUrls, siteKey);
    }

    @Deprecated
    public boolean isGenericblockAllowlisted(String url, List<String> documentUrls, String siteKey) {
        return FilterEngine.isGenericblockAllowlisted(this.ptr, url, documentUrls, siteKey);
    }

    @Deprecated
    public boolean isDocumentAllowlisted(String url, List<String> documentUrls, String siteKey) {
        return FilterEngine.isDocumentAllowlisted(this.ptr, url, documentUrls, siteKey);
    }

    @Deprecated
    public boolean isElemhideAllowlisted(String url, List<String> documentUrls, String siteKey) {
        return FilterEngine.isElemhideAllowlisted(this.ptr, url, documentUrls, siteKey);
    }

    public JsValue getPref(String pref) {
        return FilterEngine.getPref(this.ptr, pref);
    }

    public void setPref(String pref, JsValue value) {
        FilterEngine.setPref(this.ptr, pref, value.ptr);
    }

    public String getHostFromURL(String url) {
        return FilterEngine.getHostFromURL(this.ptr, url);
    }

    public void setAllowedConnectionType(String value) {
        FilterEngine.setAllowedConnectionType(this.ptr, value);
    }

    public String getAllowedConnectionType() {
        return FilterEngine.getAllowedConnectionType(this.ptr);
    }

    public void setAcceptableAdsEnabled(boolean enabled) {
        FilterEngine.setAcceptableAdsEnabled(this.ptr, enabled);
    }

    public boolean isAcceptableAdsEnabled() {
        return FilterEngine.isAcceptableAdsEnabled(this.ptr);
    }

    public String getAcceptableAdsSubscriptionURL() {
        return FilterEngine.getAcceptableAdsSubscriptionURL(this.ptr);
    }

    public void updateFiltersAsync(String subscriptionUrl) {
        FilterEngine.updateFiltersAsync(this.ptr, subscriptionUrl);
    }

    public long getNativePtr() {
        return FilterEngine.getNativePtr(this.ptr);
    }

    public void addSubscription(Subscription subscription) {
        FilterEngine.addSubscription(this.ptr, subscription.getUrl());
    }

    public void removeSubscription(Subscription subscription) {
        FilterEngine.removeSubscription(this.ptr, subscription.getUrl());
    }

    public void addFilter(Filter filter) {
        FilterEngine.addFilter(this.ptr, filter.getRaw());
    }

    public void removeFilter(Filter filter) {
        FilterEngine.removeFilter(this.ptr, filter.getRaw());
    }

    private static native void registerNatives();

    private static native Filter getFilter(long var0, String var2);

    private static native List<Filter> getListedFilters(long var0);

    private static native Subscription getSubscription(long var0, String var2, FilterEngine var3);

    private static native List<Subscription> getListedSubscriptions(long var0, FilterEngine var2);

    private static native List<Subscription> fetchAvailableSubscriptions(long var0, FilterEngine var2);

    private static native void removeFilterChangeCallback(long var0);

    private static native void setFilterChangeCallback(long var0, long var2);

    private static native String getElementHidingStyleSheet(long var0, String var2, boolean var3);

    private static native List<EmulationSelector> getElementHidingEmulationSelectors(long var0, String var2);

    private static native JsValue getPref(long var0, String var2);

    private static native Filter matches(long var0, String var2, ContentType[] var3, List<String> var4, String var5, boolean var6);

    private static native Filter matches(long var0, String var2, ContentType[] var3, String var4, String var5, boolean var6);

    private static native boolean isContentAllowlisted(long var0, String var2, ContentType[] var3, List<String> var4, String var5);

    private static native boolean isGenericblockAllowlisted(long var0, String var2, List<String> var3, String var4);

    private static native boolean isDocumentAllowlisted(long var0, String var2, List<String> var3, String var4);

    private static native boolean isElemhideAllowlisted(long var0, String var2, List<String> var3, String var4);

    private static native void setPref(long var0, String var2, long var3);

    private static native String getHostFromURL(long var0, String var2);

    private static native void setAllowedConnectionType(long var0, String var2);

    private static native String getAllowedConnectionType(long var0);

    private static native void setAcceptableAdsEnabled(long var0, boolean var2);

    private static native boolean isAcceptableAdsEnabled(long var0);

    private static native String getAcceptableAdsSubscriptionURL(long var0);

    private static native void updateFiltersAsync(long var0, String var2);

    private static native long getNativePtr(long var0);

    private static native void addSubscription(long var0, String var2);

    private static native void removeSubscription(long var0, String var2);

    static {
        System.loadLibrary("adblockplus-jni");
        FilterEngine.registerNatives();
    }

    public static class EmulationSelector {
        public String selector;
        public String text;

        public EmulationSelector(String selector, String text) {
            this.selector = selector;
            this.text = text;
        }
    }

    public static enum ContentType {
        OTHER,
        SCRIPT,
        IMAGE,
        STYLESHEET,
        OBJECT,
        SUBDOCUMENT,
        DOCUMENT,
        WEBSOCKET,
        WEBRTC,
        PING,
        XMLHTTPREQUEST,
        OBJECT_SUBREQUEST,
        MEDIA,
        FONT,
        GENERICBLOCK,
        ELEMHIDE,
        GENERICHIDE;


        public static Set<ContentType> maskOf(ContentType ... contentTypes) {
            HashSet<ContentType> set = new HashSet<ContentType>(contentTypes.length);
            for (ContentType contentType : contentTypes) {
                set.add(contentType);
            }
            return set;
        }
    }
}

