/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus;

import java.lang.ref.WeakReference;
import org.adblockplus.libadblockplus.FilterEngine;

public final class Subscription {
    protected final WeakReference<FilterEngine> filterEngine;
    protected final String url;
    private final String title;
    private final String homepage;
    private final String author;
    private final String languages;

    private Subscription(String url, String title, String homepage, String author, String languages, FilterEngine filterEngine) {
        this.url = url;
        this.title = title;
        this.homepage = homepage;
        this.author = author;
        this.languages = languages;
        this.filterEngine = new WeakReference<FilterEngine>(filterEngine);
    }

    public boolean isDisabled() {
        FilterEngine engine = (FilterEngine)this.filterEngine.get();
        if (engine == null) {
            return true;
        }
        return Subscription.isDisabled(engine.getNativePtr(), this.url);
    }

    public void setDisabled(boolean disabled) {
        FilterEngine engine = (FilterEngine)this.filterEngine.get();
        if (engine == null) {
            return;
        }
        Subscription.setDisabled(engine.getNativePtr(), disabled, this.url);
    }

    public boolean isListed() {
        FilterEngine engine = (FilterEngine)this.filterEngine.get();
        if (engine == null) {
            return false;
        }
        return engine.getListedSubscriptions().contains(this);
    }

    public void addToList() {
        FilterEngine engine = (FilterEngine)this.filterEngine.get();
        if (engine == null) {
            return;
        }
        engine.addSubscription(this);
    }

    public void removeFromList() {
        FilterEngine engine = (FilterEngine)this.filterEngine.get();
        if (engine == null) {
            return;
        }
        engine.removeSubscription(this);
    }

    public void updateFilters() {
        FilterEngine engine = (FilterEngine)this.filterEngine.get();
        if (engine == null) {
            return;
        }
        Subscription.updateFilters(engine.getNativePtr(), this.url);
    }

    public boolean isUpdating() {
        FilterEngine engine = (FilterEngine)this.filterEngine.get();
        if (engine == null) {
            return false;
        }
        return Subscription.isUpdating(engine.getNativePtr(), this.url);
    }

    public boolean isAcceptableAds() {
        FilterEngine engine = (FilterEngine)this.filterEngine.get();
        if (engine == null) {
            return false;
        }
        return Subscription.isAcceptableAds(engine.getNativePtr(), this.url);
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getLanguages() {
        return this.languages;
    }

    public String getSynchronizationStatus() {
        FilterEngine engine = (FilterEngine)this.filterEngine.get();
        if (engine == null) {
            return "Filter Engine destroyed";
        }
        return Subscription.getSynchronizationStatus(engine.getNativePtr(), this.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Subscription)) {
            return false;
        }
        return this.url.equals(((Subscription)o).url);
    }

    private static native void registerNatives();

    private static native boolean isDisabled(long var0, String var2);

    private static native void setDisabled(long var0, boolean var2, String var3);

    private static native void updateFilters(long var0, String var2);

    private static native boolean isUpdating(long var0, String var2);

    private static native boolean isAcceptableAds(long var0, String var2);

    private static native String getSynchronizationStatus(long var0, String var2);

    static {
        System.loadLibrary("adblockplus-jni");
        Subscription.registerNatives();
    }
}

