/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus.android;

import android.content.Context;
import android.text.TextUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.adblockplus.libadblockplus.Filter;
import org.adblockplus.libadblockplus.FilterEngine;
import org.adblockplus.libadblockplus.HeaderEntry;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import timber.log.Timber;

public final class Utils {
    private static final int BUFFER_SIZE = 8192;
    private static final int MAX_ARRAY_LEN = 0x7FFFFFF7;
    private static final int TO_BYTE_ARRAY_DEQUE_SIZE = 20;
    public static final Set<String> commaNotMergableHeaders = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("set-cookie", "www-authenticate", "proxy-authenticate", "expires", "date", "retry-after", "last-modified", "via")));
    private static String U2028 = new String(new byte[]{-30, -128, -88});
    private static String U2029 = new String(new byte[]{-30, -128, -87});

    private Utils() {
    }

    public static boolean isNullOrEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static String getTag(Class<?> clazz) {
        return clazz.getSimpleName();
    }

    public static String stringListToJsonArray(List<String> list) {
        JSONArray array = new JSONArray();
        if (list != null) {
            for (String eachString : list) {
                if (eachString == null) continue;
                array.put((Object)eachString);
            }
        }
        return array.toString();
    }

    public static String emulationSelectorListToJsonArray(List<FilterEngine.EmulationSelector> list) {
        JSONArray array = new JSONArray();
        if (list != null) {
            for (FilterEngine.EmulationSelector selector : list) {
                if (selector == null) continue;
                try {
                    JSONObject selectorObj = new JSONObject();
                    selectorObj.put("selector", (Object)selector.selector);
                    selectorObj.put("text", (Object)selector.text);
                    array.put((Object)selectorObj);
                }
                catch (JSONException e) {
                    Timber.e((Throwable)e, (String)"Failed to create JSON object", (Object[])new Object[0]);
                }
            }
        }
        return array.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAssetAsString(Context context, String filename, String charsetName) throws IOException {
        InputStream is = null;
        try {
            is = new BufferedInputStream(context.getAssets().open(filename));
            String string = new String(Utils.toByteArray(is), charsetName);
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getStringBeforeChar(String str, char c) {
        int pos = str.indexOf(c);
        return pos >= 0 ? str.substring(0, pos) : str;
    }

    public static String getUrlWithoutParams(String urlWithParams) {
        if (urlWithParams == null) {
            throw new IllegalArgumentException("URL can't be null");
        }
        return Utils.getStringBeforeChar(urlWithParams, '?');
    }

    public static String getUrlWithoutFragment(String url) {
        return Utils.getStringBeforeChar(url, '#');
    }

    public static String getOrigin(String url) throws MalformedURLException {
        if (url == null) {
            throw new IllegalArgumentException("URL can't be null");
        }
        URL uri = new URL(url);
        StringBuilder sb = new StringBuilder();
        sb.append(uri.getProtocol());
        sb.append("://");
        sb.append(uri.getHost());
        if (uri.getPort() != -1) {
            sb.append(":");
            sb.append(uri.getPort());
        }
        if (!TextUtils.isEmpty((CharSequence)uri.getPath()) || !TextUtils.isEmpty((CharSequence)uri.getQuery())) {
            sb.append("/");
        }
        return sb.toString();
    }

    public static String getDomain(String url) {
        if (url == null) {
            throw new IllegalArgumentException("Url can't be null");
        }
        try {
            return new URI(Utils.getStringBeforeChar(url, '?')).getHost();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static boolean isFirstPartyCookie(String documentUrl, String requestUrl, String cookieString) {
        if (documentUrl == null || requestUrl == null || cookieString == null) {
            throw new IllegalArgumentException("Arguments can't be null");
        }
        String documentDomain = Utils.getDomain(documentUrl);
        if (documentDomain == null) {
            Timber.e((String)"isFirstPartyCookie: Failed to getDomain(%s)", (Object[])new Object[]{documentUrl});
            return false;
        }
        String cookieDomain = null;
        try {
            List<HttpCookie> cookies = HttpCookie.parse(cookieString);
            if (cookies.size() > 0) {
                cookieDomain = cookies.get(0).getDomain();
            }
        }
        catch (IllegalArgumentException e) {
            Timber.e((Throwable)e, (String)"isFirstPartyCookie: Failed call to HttpCookie.parse()", (Object[])new Object[0]);
            return false;
        }
        if ((cookieDomain == null || cookieDomain.isEmpty()) && ((cookieDomain = Utils.getDomain(requestUrl)) == null || cookieDomain.isEmpty())) {
            Timber.e((String)"isFirstPartyCookie: Failed to getDomain(%s)", (Object[])new Object[]{requestUrl});
            return false;
        }
        if (cookieDomain == null || cookieDomain.isEmpty()) {
            return false;
        }
        return HttpCookie.domainMatches(cookieDomain.toLowerCase(), documentDomain.toLowerCase());
    }

    private static byte[] toByteArrayInternal(InputStream in, Deque<byte[]> bufs, int totalLen) throws IOException {
        int bufSize = 8192;
        while (totalLen < 0x7FFFFFF7) {
            byte[] buf = new byte[Math.min(bufSize, 0x7FFFFFF7 - totalLen)];
            bufs.add(buf);
            int off = 0;
            while (off < buf.length) {
                int r = in.read(buf, off, buf.length - off);
                if (r == -1) {
                    return Utils.combineBuffers(bufs, totalLen);
                }
                off += r;
                totalLen += r;
            }
            bufSize *= 2;
        }
        if (in.read() == -1) {
            return Utils.combineBuffers(bufs, 0x7FFFFFF7);
        }
        throw new OutOfMemoryError("Input is too large to fit in a byte array");
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        return Utils.toByteArrayInternal(in, new ArrayDeque<byte[]>(20), 0);
    }

    private static byte[] combineBuffers(Deque<byte[]> bufs, int totalLen) {
        int bytesToCopy;
        byte[] result = new byte[totalLen];
        for (int remaining = totalLen; remaining > 0; remaining -= bytesToCopy) {
            byte[] buf = bufs.removeFirst();
            bytesToCopy = Math.min(remaining, buf.length);
            int resultOffset = totalLen - remaining;
            System.arraycopy(buf, 0, result, resultOffset, bytesToCopy);
        }
        return result;
    }

    public static ByteBuffer readFromInputStream(InputStream inputStream) throws IOException {
        byte[] bufferBytes = Utils.toByteArray(inputStream);
        ByteBuffer buffer = ByteBuffer.allocateDirect(bufferBytes.length);
        buffer.order(ByteOrder.nativeOrder());
        buffer.put(bufferBytes);
        buffer.rewind();
        return buffer;
    }

    public static Map<String, String> convertHeaderEntriesToMap(List<HeaderEntry> headersListLowerCase) {
        HashMap<String, String> map = new HashMap<String, String>(headersListLowerCase.size());
        for (HeaderEntry header : headersListLowerCase) {
            if (!map.containsKey(header.getKey())) {
                map.put(header.getKey(), header.getValue());
                continue;
            }
            boolean skipMerge = commaNotMergableHeaders.contains(header.getKey());
            if (skipMerge) {
                Timber.d((String)"convertHeaderEntriesToMap() overwrites value of `%s` header", (Object[])new Object[]{header.getKey()});
                map.put(header.getKey(), header.getValue());
                continue;
            }
            if (((String)map.get(header.getKey())).equalsIgnoreCase(header.getValue())) {
                Timber.d((String)"convertHeaderEntriesToMap() skips duplicated value of `%s` header", (Object[])new Object[]{header.getKey()});
                continue;
            }
            String mergedValue = (String)map.get(header.getKey()) + ", " + header.getValue();
            Timber.d((String)"convertHeaderEntriesToMap() merges values of `%s` header", (Object[])new Object[]{header.getKey()});
            map.put(header.getKey(), mergedValue);
        }
        return map;
    }

    public static List<HeaderEntry> convertMapToHeadersList(Map<String, String> map) {
        ArrayList<HeaderEntry> list = new ArrayList<HeaderEntry>(map.size());
        for (Map.Entry<String, String> header : map.entrySet()) {
            list.add(new HeaderEntry(header.getKey(), header.getValue()));
        }
        return list;
    }

    public static ByteBuffer stringToByteBuffer(String string, Charset charset) {
        byte[] bytes = string.getBytes(charset);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(bytes.length);
        byteBuffer.put(bytes);
        return byteBuffer;
    }

    public static byte[] byteBufferToByteArray(ByteBuffer buffer) {
        buffer.rewind();
        byte[] bytes = new byte[buffer.limit()];
        buffer.get(bytes);
        return bytes;
    }

    public static boolean isAbsoluteUrl(String url) throws URISyntaxException {
        URI uri = new URI(url);
        return uri.isAbsolute();
    }

    public static String getAbsoluteUrl(String baseUrl, String relativeUrl) throws MalformedURLException {
        return new URL(new URL(baseUrl), relativeUrl).toExternalForm();
    }

    public static String extractPathWithQuery(String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        StringBuilder sb = new StringBuilder(url.getPath());
        if (url.getQuery() != null) {
            sb.append("?");
            sb.append(url.getQuery());
        }
        return sb.toString();
    }

    public static String escapeJavaScriptString(String line) {
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block5;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block5;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString().replace(U2028, "\u2028").replace(U2029, "\u2029");
    }

    public static boolean isSubdomainOrDomain(String host, String domain) {
        if (host.length() == 0 || domain.length() == 0 || !host.endsWith(domain)) {
            return false;
        }
        String[] domainPieces = domain.split("\\.");
        String[] hostPieces = host.split("\\.");
        if (hostPieces.length < domainPieces.length) {
            return false;
        }
        int domainLastPiece = domainPieces.length - 1;
        int hostLastPiece = hostPieces.length - 1;
        for (int piece = 0; piece <= domainLastPiece; ++piece) {
            if (hostPieces[hostLastPiece - piece].equals(domainPieces[domainLastPiece - piece])) continue;
            return false;
        }
        return true;
    }

    public static Filter createDomainAllowlistingFilter(FilterEngine filterEngine, String domain) {
        return filterEngine.getFilter("@@||" + domain + "^$document,domain=" + domain);
    }
}

