/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus;

import org.adblockplus.libadblockplus.Disposable;
import org.adblockplus.libadblockplus.Disposer;
import org.adblockplus.libadblockplus.HttpRequest;
import org.adblockplus.libadblockplus.ServerResponse;

public abstract class HttpClient {
    public static final String HEADER_REFERRER = "Referer";
    public static final String HEADER_REQUESTED_WITH = "X-Requested-With";
    public static final String HEADER_REQUESTED_WITH_XMLHTTPREQUEST = "XMLHttpRequest";
    public static final String HEADER_REQUESTED_RANGE = "Range";
    public static final String HEADER_LOCATION = "Location";
    public static final String HEADER_COOKIE = "Cookie";
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_REFRESH = "Refresh";
    public static final String HEADER_SET_COOKIE = "set-cookie";
    public static final String HEADER_WWW_AUTHENTICATE = "www-authenticate";
    public static final String HEADER_PROXY_AUTHENTICATE = "proxy-authenticate";
    public static final String HEADER_EXPIRES = "expires";
    public static final String HEADER_DATE = "date";
    public static final String HEADER_RETRY_AFTER = "retry-after";
    public static final String HEADER_LAST_MODIFIED = "last-modified";
    public static final String HEADER_VIA = "via";
    public static final String HEADER_SITEKEY = "x-adblock-key";
    public static final String HEADER_CONTENT_TYPE = "content-type";
    public static final String HEADER_CONTENT_LENGTH = "content-length";
    public static final String HEADER_CSP = "content-security-policy";
    public static final int STATUS_CODE_OK = 200;
    public static final String REQUEST_METHOD_GET = "GET";
    public static final String REQUEST_METHOD_POST = "POST";
    public static final String REQUEST_METHOD_HEAD = "HEAD";
    public static final String REQUEST_METHOD_OPTIONS = "OPTIONS";
    public static final String REQUEST_METHOD_PUT = "PUT";
    public static final String REQUEST_METHOD_DELETE = "DELETE";
    public static final String REQUEST_METHOD_TRACE = "TRACE";
    public static final String MIME_TYPE_TEXT_HTML = "text/html";

    public static boolean isRedirectCode(int httpStatusCode) {
        return httpStatusCode >= 300 && httpStatusCode <= 399;
    }

    public static boolean isValidCode(int httpStatusCode) {
        return httpStatusCode >= 100 && httpStatusCode <= 599;
    }

    public static boolean isSuccessCode(int httpStatusCode) {
        return httpStatusCode >= 200 && httpStatusCode <= 299;
    }

    public static boolean isNoContentCode(int httpStatusCode) {
        return httpStatusCode == 204 || httpStatusCode == 304 || httpStatusCode >= 100 && httpStatusCode <= 199;
    }

    public abstract void request(HttpRequest var1, Callback var2);

    private static native void callbackOnFinished(long var0, ServerResponse var2);

    private static native void callbackDtor(long var0);

    private static native void registerNatives();

    static {
        System.loadLibrary("adblockplus-jni");
        HttpClient.registerNatives();
    }

    public static class JniCallback
    implements Callback,
    Disposable {
        protected final long ptr;
        private final Disposer disposer;

        public JniCallback(long ptr) {
            this.ptr = ptr;
            this.disposer = new Disposer(this, new DisposeWrapper(this.ptr));
        }

        @Override
        public void dispose() {
            this.disposer.dispose();
        }

        @Override
        public void onFinished(ServerResponse response) {
            HttpClient.callbackOnFinished(this.ptr, response);
        }

        private static final class DisposeWrapper
        implements Disposable {
            private final long ptr;

            public DisposeWrapper(long ptr) {
                this.ptr = ptr;
            }

            @Override
            public void dispose() {
                HttpClient.callbackDtor(this.ptr);
            }
        }
    }

    public static interface Callback {
        public void onFinished(ServerResponse var1);
    }
}

