/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus;

import android.annotation.SuppressLint;
import android.util.Log;
import java.util.concurrent.LinkedBlockingQueue;
import org.adblockplus.libadblockplus.android.Utils;
import timber.log.Timber;

public final class JniExceptionHandler {
    private static final String TAG = Utils.getTag(JniExceptionHandler.class);
    private static LogWorker logWorker = null;

    public static void logException(Throwable t) {
        JniExceptionHandler.logWorker.logException(t);
    }

    static {
        logWorker = new LogWorker();
        Thread t = new Thread(logWorker);
        t.setDaemon(true);
        t.start();
    }

    private static final class LogWorker
    implements Runnable {
        LinkedBlockingQueue<Throwable> exceptionQueue = new LinkedBlockingQueue();

        private LogWorker() {
        }

        private void logException(Throwable t) {
            this.exceptionQueue.offer(t);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @SuppressLint(value={"LogNotTimber"})
        public void run() {
            try {
                while (true) {
                    Throwable t = this.exceptionQueue.take();
                    if (Timber.treeCount() > 0) {
                        Timber.e((Throwable)t, (String)"Exception from JNI", (Object[])new Object[0]);
                        continue;
                    }
                    Log.e((String)TAG, (String)"Exception from JNI", (Throwable)t);
                }
            }
            catch (InterruptedException ie) {}
            finally {
                return;
            }
        }
    }
}

