/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus;

import java.util.List;
import org.adblockplus.libadblockplus.EventCallback;
import org.adblockplus.libadblockplus.JsValue;

public final class JsEngine {
    protected final long ptr;

    JsEngine(long ptr) {
        this.ptr = ptr;
    }

    public void setEventCallback(String eventName, EventCallback callback) {
        JsEngine.setEventCallback(this.ptr, eventName, callback.ptr);
    }

    public void removeEventCallback(String eventName) {
        JsEngine.removeEventCallback(this.ptr, eventName);
    }

    public JsValue evaluate(String source, String filename) {
        return JsEngine.evaluate(this.ptr, source, filename);
    }

    public JsValue evaluate(String source) {
        return JsEngine.evaluate(this.ptr, source, "");
    }

    public void setGlobalProperty(String property, JsValue value) {
        JsEngine.setGlobalProperty(this.ptr, property, value.ptr);
    }

    public void triggerEvent(String eventName, List<JsValue> params) {
        long[] args = new long[params.size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = params.get((int)i).ptr;
        }
        JsEngine.triggerEvent(this.ptr, eventName, args);
    }

    public void onLowMemory() {
        JsEngine.onLowMemory(this.ptr);
    }

    public void triggerEvent(String eventName) {
        JsEngine.triggerEvent(this.ptr, eventName, null);
    }

    public JsValue newValue(long value) {
        return JsEngine.newValue(this.ptr, value);
    }

    public JsValue newValue(boolean value) {
        return JsEngine.newValue(this.ptr, value);
    }

    public JsValue newValue(String value) {
        return JsEngine.newValue(this.ptr, value);
    }

    private static native void registerNatives();

    private static native void setEventCallback(long var0, String var2, long var3);

    private static native void removeEventCallback(long var0, String var2);

    private static native JsValue evaluate(long var0, String var2, String var3);

    private static native void triggerEvent(long var0, String var2, long[] var3);

    private static native JsValue newValue(long var0, long var2);

    private static native JsValue newValue(long var0, boolean var2);

    private static native JsValue newValue(long var0, String var2);

    private static native void setGlobalProperty(long var0, String var2, long var3);

    private static native void onLowMemory(long var0);

    static {
        System.loadLibrary("adblockplus-jni");
        JsEngine.registerNatives();
    }
}

