/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus;

import java.util.Collections;
import java.util.List;
import org.adblockplus.libadblockplus.Disposable;
import org.adblockplus.libadblockplus.Disposer;

public class JsValue
implements Disposable {
    private final Disposer disposer;
    protected final long ptr;

    protected JsValue(long ptr) {
        this.ptr = ptr;
        this.disposer = new Disposer(this, new DisposeWrapper(ptr));
    }

    @Override
    public void dispose() {
        this.disposer.dispose();
    }

    public boolean isUndefined() {
        return JsValue.isUndefined(this.ptr);
    }

    public boolean isNull() {
        return JsValue.isNull(this.ptr);
    }

    public boolean isString() {
        return JsValue.isString(this.ptr);
    }

    public boolean isNumber() {
        return JsValue.isNumber(this.ptr);
    }

    public boolean isBoolean() {
        return JsValue.isBoolean(this.ptr);
    }

    public boolean isObject() {
        return JsValue.isObject(this.ptr);
    }

    public boolean isArray() {
        return JsValue.isArray(this.ptr);
    }

    public boolean isFunction() {
        return JsValue.isFunction(this.ptr);
    }

    public String asString() {
        return JsValue.asString(this.ptr);
    }

    public long asLong() {
        return JsValue.asLong(this.ptr);
    }

    public boolean asBoolean() {
        return JsValue.asBoolean(this.ptr);
    }

    protected long[] convertToPtrArray(List<JsValue> params) {
        long[] paramPtrs = new long[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            paramPtrs[i] = params.get((int)i).ptr;
        }
        return paramPtrs;
    }

    public JsValue call(List<JsValue> params) {
        return JsValue.call(this.ptr, this.convertToPtrArray(params));
    }

    public JsValue call(List<JsValue> params, JsValue thisValue) {
        return JsValue.call(this.ptr, this.convertToPtrArray(params), thisValue.ptr);
    }

    public JsValue call() {
        return this.call(Collections.emptyList());
    }

    public JsValue getProperty(String name) {
        return JsValue.getProperty(this.ptr, name);
    }

    public void setProperty(String name, JsValue value) {
        JsValue.setProperty(this.ptr, name, value.ptr);
    }

    public String getJsClass() {
        return JsValue.getJsClass(this.ptr);
    }

    public List<String> getOwnPropertyNames() {
        return JsValue.getOwnPropertyNames(this.ptr);
    }

    public List<JsValue> asList() {
        return JsValue.asList(this.ptr);
    }

    public String toString() {
        return JsValue.asString(this.ptr);
    }

    private static native void registerNatives();

    private static native boolean isUndefined(long var0);

    private static native boolean isNull(long var0);

    private static native boolean isString(long var0);

    private static native boolean isNumber(long var0);

    private static native boolean isBoolean(long var0);

    private static native boolean isObject(long var0);

    private static native boolean isArray(long var0);

    private static native boolean isFunction(long var0);

    private static native String asString(long var0);

    private static native long asLong(long var0);

    private static native boolean asBoolean(long var0);

    private static native JsValue getProperty(long var0, String var2);

    private static native void setProperty(long var0, String var2, long var3);

    private static native String getJsClass(long var0);

    private static native List<String> getOwnPropertyNames(long var0);

    private static native List<JsValue> asList(long var0);

    private static native JsValue call(long var0, long[] var2);

    private static native JsValue call(long var0, long[] var2, long var3);

    private static native void dtor(long var0);

    static {
        System.loadLibrary("adblockplus-jni");
        JsValue.registerNatives();
    }

    private static final class DisposeWrapper
    implements Disposable {
        private final long ptr;

        public DisposeWrapper(long ptr) {
            this.ptr = ptr;
        }

        @Override
        public void dispose() {
            JsValue.dtor(this.ptr);
        }
    }
}

