/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus;

import org.adblockplus.libadblockplus.AppInfo;
import org.adblockplus.libadblockplus.Disposable;
import org.adblockplus.libadblockplus.Disposer;
import org.adblockplus.libadblockplus.FileSystem;
import org.adblockplus.libadblockplus.FilterEngine;
import org.adblockplus.libadblockplus.HttpClient;
import org.adblockplus.libadblockplus.IsAllowedConnectionCallback;
import org.adblockplus.libadblockplus.JsEngine;
import org.adblockplus.libadblockplus.LogSystem;

public class Platform
implements Disposable {
    private final Disposer disposer;
    protected final long ptr;

    public Platform(LogSystem logSystem, FileSystem fileSystem, HttpClient httpClient, String basePath) {
        this(Platform.ctor(logSystem, fileSystem, httpClient, basePath));
    }

    protected Platform(long ptr) {
        this.ptr = ptr;
        this.disposer = new Disposer(this, new DisposeWrapper(ptr));
    }

    public void setUpJsEngine(AppInfo appInfo, long v8IsolateProviderPtr) {
        Platform.setUpJsEngine(this.ptr, appInfo, v8IsolateProviderPtr);
    }

    public void setUpJsEngine(AppInfo appInfo) {
        this.setUpJsEngine(appInfo, 0L);
    }

    public JsEngine getJsEngine() {
        return new JsEngine(Platform.getJsEnginePtr(this.ptr));
    }

    public void setUpFilterEngine(IsAllowedConnectionCallback isSubscriptionDownloadAllowedCallback, boolean isFilterEngineEnabled) {
        Platform.setUpFilterEngine(this.ptr, isSubscriptionDownloadAllowedCallback, isFilterEngineEnabled);
    }

    public FilterEngine getFilterEngine() {
        Platform.ensureFilterEngine(this.ptr);
        return new FilterEngine(this.ptr);
    }

    @Override
    public void dispose() {
        this.disposer.dispose();
    }

    private static native void registerNatives();

    private static native long ctor(LogSystem var0, FileSystem var1, HttpClient var2, String var3);

    private static native void setUpJsEngine(long var0, AppInfo var2, long var3);

    private static native long getJsEnginePtr(long var0);

    private static native void setUpFilterEngine(long var0, IsAllowedConnectionCallback var2, boolean var3);

    private static native void ensureFilterEngine(long var0);

    private static native void dtor(long var0);

    static {
        System.loadLibrary("adblockplus-jni");
        Platform.registerNatives();
    }

    private static final class DisposeWrapper
    implements Disposable {
        private final long ptr;

        public DisposeWrapper(long ptr) {
            this.ptr = ptr;
        }

        @Override
        public void dispose() {
            Platform.dtor(this.ptr);
        }
    }
}

