/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.adblockplus.libadblockplus.HeaderEntry;

public final class ServerResponse {
    private long status = NsStatus.OK.getStatusCode();
    private String finalUrl;
    private int responseStatus = 400;
    private String[] headers = null;
    private ByteBuffer response = null;
    private InputStream inputStream = null;

    public NsStatus getStatus() {
        return NsStatus.fromStatusCode(this.status);
    }

    public void setStatus(NsStatus status) {
        this.status = status.getStatusCode();
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public void setResponseStatus(int status) {
        this.responseStatus = status;
    }

    public ByteBuffer getResponse() {
        return this.response;
    }

    public void setResponse(ByteBuffer response) {
        this.response = response;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public List<HeaderEntry> getResponseHeaders() {
        ArrayList<HeaderEntry> ret = new ArrayList<HeaderEntry>();
        if (this.headers != null) {
            for (int i = 0; i < this.headers.length; i += 2) {
                ret.add(HeaderEntry.of(this.headers[i], this.headers[i + 1]));
            }
        }
        return ret;
    }

    public void setResponseHeaders(List<HeaderEntry> headers) {
        if (headers.isEmpty()) {
            this.headers = null;
        } else {
            this.headers = new String[headers.size() * 2];
            int i = 0;
            for (HeaderEntry e : headers) {
                this.headers[i] = e.getKey();
                this.headers[i + 1] = e.getValue();
                i += 2;
            }
        }
    }

    public String getFinalUrl() {
        return this.finalUrl;
    }

    public void setFinalUrl(String url) {
        this.finalUrl = url;
    }

    public static enum NsStatus {
        OK(0L),
        ERROR_FAILURE(2147500037L),
        ERROR_OUT_OF_MEMORY(2147942414L),
        ERROR_MALFORMED_URI(2152398858L),
        ERROR_CONNECTION_REFUSED(2152398861L),
        ERROR_NET_TIMEOUT(2152398862L),
        ERROR_NO_CONTENT(2152398865L),
        ERROR_UNKNOWN_PROTOCOL(2152398866L),
        ERROR_NET_RESET(2152398868L),
        ERROR_UNKNOWN_HOST(2152398878L),
        ERROR_REDIRECT_LOOP(2152398879L),
        ERROR_UNKNOWN_PROXY_HOST(2152398890L),
        ERROR_NET_INTERRUPT(2152398919L),
        ERROR_UNKNOWN_PROXY_CONNECTION_REFUSED(2152398920L),
        CUSTOM_ERROR_BASE(0x80850000L),
        ERROR_NOT_INITIALIZED(3253927937L);

        private final long statusCode;
        private static final HashMap<Long, NsStatus> ENUM_MAP;

        private NsStatus(long value) {
            this.statusCode = value;
        }

        public long getStatusCode() {
            return this.statusCode;
        }

        public static NsStatus fromStatusCode(long code) {
            NsStatus status = ENUM_MAP.get(code);
            return status != null ? status : ERROR_FAILURE;
        }

        static {
            ENUM_MAP = new HashMap();
            for (NsStatus e : NsStatus.values()) {
                ENUM_MAP.put(e.statusCode, e);
            }
        }
    }
}

