/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus.android;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import org.adblockplus.libadblockplus.IsAllowedConnectionCallback;
import org.adblockplus.libadblockplus.android.ConnectionType;
import timber.log.Timber;

public class IsAllowedConnectionCallbackImpl
implements IsAllowedConnectionCallback {
    private ConnectivityManager manager;

    public IsAllowedConnectionCallbackImpl(ConnectivityManager manager) {
        this.manager = manager;
    }

    @Override
    public boolean isConnectionAllowed(String connection) {
        Timber.d((String)"Checking connection: %s", (Object[])new Object[]{connection});
        if (connection == null) {
            return true;
        }
        NetworkInfo info = this.manager.getActiveNetworkInfo();
        if (info == null || !info.isConnected()) {
            return false;
        }
        ConnectionType connectionType = ConnectionType.findByValue(connection);
        if (connectionType == null) {
            Timber.e((String)"Unknown connection type: %s", (Object[])new Object[]{connection});
            return false;
        }
        if (!connectionType.isRequiredConnection(this.manager)) {
            Timber.w((String)"Current connection type is not allowed for web requests", (Object[])new Object[0]);
            return false;
        }
        return true;
    }
}

