/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus.android;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.adblockplus.libadblockplus.android.AdblockEngine;
import org.adblockplus.libadblockplus.android.AdblockEngineProvider;
import timber.log.Timber;

public class SingleInstanceEngineProvider
implements AdblockEngineProvider {
    private AdblockEngine.Factory engineFactory;
    private AtomicReference<AdblockEngine> engineReference = new AtomicReference();
    private List<AdblockEngineProvider.EngineCreatedListener> engineCreatedListeners = new CopyOnWriteArrayList<AdblockEngineProvider.EngineCreatedListener>();
    private List<AdblockEngineProvider.BeforeEngineDisposedListener> beforeEngineDisposedListeners = new CopyOnWriteArrayList<AdblockEngineProvider.BeforeEngineDisposedListener>();
    private List<AdblockEngineProvider.EngineDisposedListener> engineDisposedListeners = new CopyOnWriteArrayList<AdblockEngineProvider.EngineDisposedListener>();
    private final ReentrantReadWriteLock engineLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock referenceCounterLock = new ReentrantReadWriteLock();
    private final ExecutorService executorService;
    private AtomicInteger referenceCounter = new AtomicInteger(0);
    private final Runnable retainTask = new Runnable(){

        @Override
        public void run() {
            Timber.w((String)("Waiting for lock in " + Thread.currentThread()), (Object[])new Object[0]);
            SingleInstanceEngineProvider.this.engineLock.writeLock().lock();
            try {
                SingleInstanceEngineProvider.this.createAdblock();
            }
            finally {
                SingleInstanceEngineProvider.this.engineLock.writeLock().unlock();
            }
        }
    };
    private final Runnable waitForTheTasksTask = new Runnable(){

        @Override
        public void run() {
        }
    };
    private final Runnable releaseTask = new Runnable(){

        @Override
        public void run() {
            Timber.w((String)("Waiting for lock in " + Thread.currentThread()), (Object[])new Object[0]);
            SingleInstanceEngineProvider.this.engineLock.writeLock().lock();
            try {
                SingleInstanceEngineProvider.this.disposeAdblock();
            }
            finally {
                SingleInstanceEngineProvider.this.engineLock.writeLock().unlock();
            }
        }
    };

    public SingleInstanceEngineProvider(AdblockEngine.Factory engineFactory) {
        this.engineFactory = engineFactory;
        this.executorService = this.createExecutorService();
    }

    protected ExecutorService createExecutorService() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Runtime.getRuntime().addShutdownHook(new ExecutorServiceShutdownHook(executorService));
        return executorService;
    }

    @Override
    public SingleInstanceEngineProvider addEngineCreatedListener(AdblockEngineProvider.EngineCreatedListener listener) {
        this.engineCreatedListeners.add(listener);
        return this;
    }

    @Override
    public void removeEngineCreatedListener(AdblockEngineProvider.EngineCreatedListener listener) {
        this.engineCreatedListeners.remove(listener);
    }

    @Override
    public void clearEngineCreatedListeners() {
        this.engineCreatedListeners.clear();
    }

    @Override
    public SingleInstanceEngineProvider addBeforeEngineDisposedListener(AdblockEngineProvider.BeforeEngineDisposedListener listener) {
        this.beforeEngineDisposedListeners.add(listener);
        return this;
    }

    @Override
    public void removeBeforeEngineDisposedListener(AdblockEngineProvider.BeforeEngineDisposedListener listener) {
        this.beforeEngineDisposedListeners.remove(listener);
    }

    @Override
    public void clearBeforeEngineDisposedListeners() {
        this.beforeEngineDisposedListeners.clear();
    }

    @Override
    public SingleInstanceEngineProvider addEngineDisposedListener(AdblockEngineProvider.EngineDisposedListener listener) {
        this.engineDisposedListeners.add(listener);
        return this;
    }

    @Override
    public void removeEngineDisposedListener(AdblockEngineProvider.EngineDisposedListener listener) {
        this.engineDisposedListeners.remove(listener);
    }

    @Override
    public void clearEngineDisposedListeners() {
        this.engineDisposedListeners.clear();
    }

    private void createAdblock() {
        Timber.d((String)"Creating adblock engine ...", (Object[])new Object[0]);
        AdblockEngine engine = this.engineFactory.build();
        Timber.d((String)"Engine created", (Object[])new Object[0]);
        this.engineReference.set(engine);
        for (AdblockEngineProvider.EngineCreatedListener listener : this.engineCreatedListeners) {
            listener.onAdblockEngineCreated(engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retain(boolean asynchronous) {
        Future future;
        this.referenceCounterLock.writeLock().lock();
        try {
            boolean firstInstance;
            boolean bl = firstInstance = this.referenceCounter.getAndIncrement() == 0;
            if (!firstInstance) {
                boolean bl2 = false;
                return bl2;
            }
            future = this.scheduleTask(this.retainTask);
        }
        finally {
            this.referenceCounterLock.writeLock().unlock();
        }
        if (!asynchronous) {
            this.waitForTask(future);
        }
        return true;
    }

    @Override
    public void waitForReady() {
        Timber.d((String)"Waiting for ready in %s", (Object[])new Object[]{Thread.currentThread()});
        this.waitForTask(this.scheduleTask(this.waitForTheTasksTask));
        Timber.d((String)"Ready", (Object[])new Object[0]);
    }

    @Override
    public AdblockEngine getEngine() {
        return this.engineReference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean release() {
        Future future;
        this.referenceCounterLock.writeLock().lock();
        try {
            boolean lastInstance;
            boolean bl = lastInstance = this.referenceCounter.decrementAndGet() == 0;
            if (!lastInstance) {
                boolean bl2 = false;
                return bl2;
            }
            future = this.scheduleTask(this.releaseTask);
        }
        finally {
            this.referenceCounterLock.writeLock().unlock();
        }
        this.waitForTask(future);
        return true;
    }

    private Future scheduleTask(Runnable task) {
        return this.executorService.submit(task);
    }

    private void waitForTask(Future future) throws RuntimeException {
        try {
            future.get();
        }
        catch (Exception e) {
            Timber.e((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void disposeAdblock() {
        Timber.w((String)"Disposing adblock engine", (Object[])new Object[0]);
        for (AdblockEngineProvider.BeforeEngineDisposedListener beforeEngineDisposedListener : this.beforeEngineDisposedListeners) {
            beforeEngineDisposedListener.onBeforeAdblockEngineDispose();
        }
        ((AdblockEngine)this.engineReference.getAndSet(null)).dispose();
        for (AdblockEngineProvider.EngineDisposedListener engineDisposedListener : this.engineDisposedListeners) {
            engineDisposedListener.onAdblockEngineDisposed();
        }
    }

    @Override
    public int getCounter() {
        this.referenceCounterLock.readLock().lock();
        try {
            int n = this.referenceCounter.get();
            return n;
        }
        finally {
            this.referenceCounterLock.readLock().unlock();
        }
    }

    @Override
    public ReentrantReadWriteLock.ReadLock getReadEngineLock() {
        Timber.d((String)("getReadEngineLock() called from " + Thread.currentThread()), (Object[])new Object[0]);
        return this.engineLock.readLock();
    }

    private static class ExecutorServiceShutdownHook
    extends Thread {
        private final ExecutorService executorService;

        private ExecutorServiceShutdownHook(ExecutorService executorService) {
            Timber.w((String)"Hooking on executor service %s", (Object[])new Object[]{executorService});
            this.executorService = executorService;
        }

        @Override
        public void run() {
            Timber.w((String)"Shutting down executor service %s", (Object[])new Object[]{this.executorService});
            this.executorService.shutdown();
        }
    }
}

