/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus.security;

import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import org.adblockplus.libadblockplus.security.SignatureVerificationException;
import org.adblockplus.libadblockplus.security.SignatureVerifier;

public class JavaSignatureVerifier
implements SignatureVerifier {
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private String signatureAlgorithm;

    public static PublicKey publicKeyFromDer(String keyAlgorithm, byte[] publicKeyBytes) throws SignatureVerificationException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm);
            return keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyBytes));
        }
        catch (Throwable cause) {
            throw new SignatureVerificationException(cause);
        }
    }

    public JavaSignatureVerifier(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public JavaSignatureVerifier() {
        this(SIGNATURE_ALGORITHM);
    }

    @Override
    public boolean verify(PublicKey publicKey, byte[] data, byte[] signatureBytes) throws SignatureVerificationException {
        try {
            Signature signature = Signature.getInstance(this.signatureAlgorithm);
            signature.initVerify(publicKey);
            signature.update(data);
            return signature.verify(signatureBytes);
        }
        catch (Throwable cause) {
            throw new SignatureVerificationException(cause);
        }
    }
}

