/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus.sitekey;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.adblockplus.libadblockplus.sitekey.PublicKeyHolder;

public class PublicKeyHolderImpl
implements PublicKeyHolder {
    private Map<String, String> map = Collections.synchronizedMap(new HashMap());

    public static String stripPadding(String publicKey) {
        if (publicKey == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(publicKey);
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == '=') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public boolean contains(String url) {
        return this.map.containsKey(url);
    }

    @Override
    public String get(String url) {
        return this.map.get(url);
    }

    @Override
    public String getAny(List<String> urls, String defaultValue) {
        for (String url : urls) {
            String publicKey = this.get(url);
            if (publicKey == null) continue;
            return publicKey;
        }
        return defaultValue;
    }

    @Override
    public void put(String url, String publicKey) {
        this.map.put(url, publicKey);
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

