/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus.sitekey;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.PublicKey;
import java.util.Map;
import org.adblockplus.libadblockplus.android.Utils;
import org.adblockplus.libadblockplus.security.JavaSignatureVerifier;
import org.adblockplus.libadblockplus.security.SignatureVerificationException;
import org.adblockplus.libadblockplus.security.SignatureVerifier;
import org.adblockplus.libadblockplus.sitekey.PublicKeyHolder;
import org.adblockplus.libadblockplus.sitekey.SiteKeyException;
import org.adblockplus.libadblockplus.util.Base64Exception;
import org.adblockplus.libadblockplus.util.Base64Processor;
import timber.log.Timber;

public class SiteKeyVerifier {
    private static final byte ZERO_BYTE = 0;
    private final SignatureVerifier signatureVerifier;
    private final PublicKeyHolder publicKeyHolder;
    private final Base64Processor base64Processor;

    public SiteKeyVerifier(SignatureVerifier signatureVerifier, PublicKeyHolder publicKeyHolder, Base64Processor base64Processor) {
        this.signatureVerifier = signatureVerifier;
        this.publicKeyHolder = publicKeyHolder;
        this.base64Processor = base64Processor;
    }

    public boolean verify(String url, String userAgent, String value) throws SiteKeyException {
        String[] parts = value.split("_");
        if (parts.length != 2) {
            throw new SiteKeyException("Value is expected to be in format: publicKey_signature, but actual parts count is " + parts.length);
        }
        String publicKeyString = parts[0];
        String signature = parts[1];
        byte[] publicKeyBytes = this.decodeBase64(publicKeyString);
        byte[] signatureBytes = this.decodeBase64(signature);
        byte[] dataBytes = this.buildData(url, userAgent);
        try {
            PublicKey publicKey = JavaSignatureVerifier.publicKeyFromDer("RSA", publicKeyBytes);
            if (this.signatureVerifier.verify(publicKey, dataBytes, signatureBytes)) {
                this.publicKeyHolder.put(url, publicKeyString);
                return true;
            }
            return false;
        }
        catch (SignatureVerificationException e) {
            throw new SiteKeyException(e);
        }
    }

    public void verifyInHeaders(String url, Map<String, String> requestHeadersMap, Map<String, String> responseHeaders) {
        for (Map.Entry<String, String> header : responseHeaders.entrySet()) {
            if (!header.getKey().equals("x-adblock-key")) continue;
            try {
                if (this.verify(Utils.getUrlWithoutFragment(url), requestHeadersMap.get("User-Agent"), header.getValue())) {
                    Timber.d((String)"Url %s public key verified successfully", (Object[])new Object[]{url});
                    break;
                }
                Timber.e((String)"Url %s public key is not verified", (Object[])new Object[]{url});
            }
            catch (SiteKeyException e) {
                Timber.e((Throwable)e, (String)"Failed to verify sitekey header", (Object[])new Object[0]);
            }
            break;
        }
    }

    private byte[] decodeBase64(String encodedString) throws SiteKeyException {
        try {
            return this.base64Processor.decode(encodedString.getBytes());
        }
        catch (Base64Exception cause) {
            throw new SiteKeyException(cause);
        }
    }

    protected byte[] buildData(String url, String userAgent) throws SiteKeyException {
        URI uri;
        try {
            uri = new URI(url);
            if (uri.getHost() == null) {
                throw new URISyntaxException(url, "Can't extract host from URI");
            }
        }
        catch (URISyntaxException cause) {
            throw new SiteKeyException(cause);
        }
        String path = uri.getPath() != null && !uri.getPath().isEmpty() ? uri.getPath() : "/";
        StringBuilder uriBuilder = new StringBuilder(path);
        if (uri.getQuery() != null) {
            uriBuilder.append("?");
            uriBuilder.append(uri.getRawQuery());
        }
        byte[] urlBytes = uriBuilder.toString().getBytes();
        byte[] hostBytes = uri.getAuthority().getBytes();
        byte[] userAgentBytes = userAgent != null ? userAgent.getBytes() : new byte[]{};
        byte[] data = new byte[urlBytes.length + 1 + hostBytes.length + 1 + userAgentBytes.length];
        System.arraycopy(urlBytes, 0, data, 0, urlBytes.length);
        data[urlBytes.length] = 0;
        System.arraycopy(hostBytes, 0, data, urlBytes.length + 1, hostBytes.length);
        data[urlBytes.length + 1 + hostBytes.length] = 0;
        System.arraycopy(userAgentBytes, 0, data, urlBytes.length + 1 + hostBytes.length + 1, userAgentBytes.length);
        return data;
    }
}

