/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.AlreadyClosedException;
import org.apache.activemq.EnhancedConnection;
import org.apache.activemq.advisory.DestinationSource;
import org.apache.activemq.pool.ConnectionPool;
import org.apache.activemq.pool.PooledSession;
import org.apache.activemq.pool.PooledSessionEventListener;
import org.apache.activemq.pool.SessionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledConnection
implements TopicConnection,
QueueConnection,
EnhancedConnection,
PooledSessionEventListener {
    private static final transient Logger LOG = LoggerFactory.getLogger(PooledConnection.class);
    private ConnectionPool pool;
    private volatile boolean stopped;
    private final List<TemporaryQueue> connTempQueues = new CopyOnWriteArrayList<TemporaryQueue>();
    private final List<TemporaryTopic> connTempTopics = new CopyOnWriteArrayList<TemporaryTopic>();
    private final List<PooledSession> loanedSessions = new CopyOnWriteArrayList<PooledSession>();

    public PooledConnection(ConnectionPool pool) {
        this.pool = pool;
        this.pool.incrementReferenceCount();
    }

    public PooledConnection newInstance() {
        return new PooledConnection(this.pool);
    }

    public void close() throws JMSException {
        this.cleanupConnectionTemporaryDestinations();
        this.cleanupAllLoanedSessions();
        if (this.pool != null) {
            this.pool.decrementReferenceCount();
            this.pool = null;
        }
    }

    public void start() throws JMSException {
        this.assertNotClosed();
        this.pool.start();
    }

    public void stop() throws JMSException {
        this.stopped = true;
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String selector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer(destination, selector, serverSessionPool, maxMessages);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String s, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer(topic, s, serverSessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String selector, String s1, ServerSessionPool serverSessionPool, int i) throws JMSException {
        return this.getConnection().createDurableConnectionConsumer(topic, selector, s1, serverSessionPool, i);
    }

    public String getClientID() throws JMSException {
        return this.getConnection().getClientID();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.getConnection().getExceptionListener();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.getConnection().getMetaData();
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.getConnection().setExceptionListener(exceptionListener);
    }

    public void setClientID(String clientID) throws JMSException {
        if (this.getConnection().getClientID() == null || !this.getClientID().equals(clientID)) {
            this.getConnection().setClientID(clientID);
        }
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String selector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer(queue, selector, serverSessionPool, maxMessages);
    }

    public QueueSession createQueueSession(boolean transacted, int ackMode) throws JMSException {
        return (QueueSession)this.createSession(transacted, ackMode);
    }

    public TopicSession createTopicSession(boolean transacted, int ackMode) throws JMSException {
        return (TopicSession)this.createSession(transacted, ackMode);
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        PooledSession result = (PooledSession)this.pool.createSession(transacted, ackMode);
        this.loanedSessions.add(result);
        result.addSessionEventListener(this);
        return result;
    }

    public DestinationSource getDestinationSource() throws JMSException {
        return this.getConnection().getDestinationSource();
    }

    @Override
    public void onTemporaryQueueCreate(TemporaryQueue tempQueue) {
        this.connTempQueues.add(tempQueue);
    }

    @Override
    public void onTemporaryTopicCreate(TemporaryTopic tempTopic) {
        this.connTempTopics.add(tempTopic);
    }

    @Override
    public void onSessionClosed(PooledSession session) {
        if (session != null) {
            this.loanedSessions.remove(session);
        }
    }

    public ActiveMQConnection getConnection() throws JMSException {
        this.assertNotClosed();
        return this.pool.getConnection();
    }

    protected void assertNotClosed() throws AlreadyClosedException {
        if (this.stopped || this.pool == null) {
            throw new AlreadyClosedException();
        }
    }

    protected ActiveMQSession createSession(SessionKey key) throws JMSException {
        return (ActiveMQSession)this.getConnection().createSession(key.isTransacted(), key.getAckMode());
    }

    public String toString() {
        return "PooledConnection { " + this.pool + " }";
    }

    protected void cleanupConnectionTemporaryDestinations() {
        for (TemporaryQueue tempQueue : this.connTempQueues) {
            try {
                tempQueue.delete();
            }
            catch (JMSException ex) {
                LOG.info("failed to delete Temporary Queue \"" + tempQueue.toString() + "\" on closing pooled connection: " + ex.getMessage());
            }
        }
        this.connTempQueues.clear();
        for (TemporaryTopic tempTopic : this.connTempTopics) {
            try {
                tempTopic.delete();
            }
            catch (JMSException ex) {
                LOG.info("failed to delete Temporary Topic \"" + tempTopic.toString() + "\" on closing pooled connection: " + ex.getMessage());
            }
        }
        this.connTempTopics.clear();
    }

    protected void cleanupAllLoanedSessions() {
        for (PooledSession session : this.loanedSessions) {
            try {
                session.close();
            }
            catch (JMSException ex) {
                LOG.info("failed to close laoned Session \"" + session + "\" on closing pooled connection: " + ex.getMessage());
            }
        }
        this.loanedSessions.clear();
    }

    public int getNumSessions() {
        return this.pool.getNumSessions();
    }

    public int getNumActiveSessions() {
        return this.pool.getNumActiveSessions();
    }

    public int getNumtIdleSessions() {
        return this.pool.getNumIdleSessions();
    }
}

