/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.testutils;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.testutils.PortAllocator;
import org.apache.axis2.transport.http.SimpleHTTPServer;
import org.junit.rules.ExternalResource;

public class Axis2Server
extends ExternalResource {
    private final String repositoryPath;
    private int port = -1;
    private ConfigurationContext configurationContext;
    private SimpleHTTPServer server;

    public Axis2Server(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    public int getPort() {
        if (this.port == -1) {
            throw new IllegalStateException();
        }
        return this.port;
    }

    public String getEndpoint(String serviceName) throws AxisFault {
        if (this.configurationContext == null) {
            throw new IllegalStateException();
        }
        return this.configurationContext.getAxisConfiguration().getService(serviceName).getEPRs()[0];
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    protected void before() throws Throwable {
        this.port = PortAllocator.allocatePort();
        this.configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)this.repositoryPath);
        this.server = new SimpleHTTPServer(this.configurationContext, this.port);
        this.server.start();
    }

    protected void after() {
        this.port = -1;
        this.configurationContext = null;
        this.server.stop();
        this.server = null;
    }
}

