/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.osgi.deployment.tracker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.osgi.deployment.BundleClassLoader;
import org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver;
import org.apache.axis2.rpc.receivers.RPCMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class WSTracker {
    private boolean open;
    private final Lock lock = new ReentrantLock();
    private BundleContext context;
    private ServiceListener serviceListener;
    private static Log log = LogFactory.getLog(WSTracker.class);
    private List<Bundle> bundleList = new ArrayList<Bundle>();
    public static String AXIS2_WS = "org.apache.axis2.osgi.ws";
    private ConfigurationContext configCtx;

    public WSTracker(ConfigurationContext configCtx, BundleContext context) {
        this.context = context;
        this.configCtx = configCtx;
        this.serviceListener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                int serviceType = event.getType();
                try {
                    switch (serviceType) {
                        case 1: {
                            ServiceReference reference = event.getServiceReference();
                            WSTracker.this.createWS(reference.getBundle(), event.getServiceReference());
                            break;
                        }
                    }
                }
                catch (AxisFault e) {
                    String msg = "Error while creating AxisService";
                    log.error((Object)msg, (Throwable)e);
                }
            }
        };
    }

    public void open() {
        if (this.open) {
            return;
        }
        this.open = true;
        for (Bundle bundle : this.context.getBundles()) {
            if (bundle == this.context.getBundle()) continue;
            ServiceReference[] references = bundle.getRegisteredServices();
            try {
                this.createWS(bundle, references);
            }
            catch (AxisFault e) {
                String msg = "Error while creating AxisService from bundle : " + bundle.getBundleId();
                log.error((Object)msg, (Throwable)e);
            }
            this.bundleList.add(bundle);
        }
        this.context.addServiceListener(this.serviceListener);
    }

    private void createWS(Bundle bundle, ServiceReference[] references) throws AxisFault {
        if (bundle != null && references != null) {
            for (ServiceReference reference : references) {
                this.createWS(bundle, reference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWS(Bundle bundle, ServiceReference reference) throws AxisFault {
        if (bundle != null && reference != null) {
            Object axis2Ws = reference.getProperty(AXIS2_WS);
            if (axis2Ws == null) {
                return;
            }
            String wsName = axis2Ws.toString();
            this.lock.lock();
            try {
                Object service = this.context.getService(reference);
                AxisService axisService = AxisService.createService(service.getClass().getName(), this.configCtx.getAxisConfiguration(), this.createDefaultMessageReceivers(), null, null, new BundleClassLoader(bundle, WSTracker.class.getClassLoader()));
                axisService.setName(wsName);
                this.configCtx.getAxisConfiguration().addService(axisService);
                log.info((Object)("Added new WS from ServiceReference : " + service.getClass().getName()));
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private Map createDefaultMessageReceivers() throws AxisFault {
        HashMap<String, MessageReceiver> messageReciverMap = new HashMap<String, MessageReceiver>();
        try {
            MessageReceiver messageReceiver = (MessageReceiver)RPCInOnlyMessageReceiver.class.newInstance();
            messageReciverMap.put("http://www.w3.org/ns/wsdl/in-only", messageReceiver);
            MessageReceiver inOutmessageReceiver = (MessageReceiver)RPCMessageReceiver.class.newInstance();
            messageReciverMap.put("http://www.w3.org/ns/wsdl/in-out", inOutmessageReceiver);
            messageReciverMap.put("http://www.w3.org/ns/wsdl/robust-in-only", inOutmessageReceiver);
        }
        catch (InstantiationException e) {
            String msg = "Message receivers cannot be instantiated";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Illegal access";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, e);
        }
        return messageReciverMap;
    }
}

