/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.WriteResponse;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterMutationVerbHandler
implements IVerbHandler {
    private static Logger logger = LoggerFactory.getLogger(CounterMutationVerbHandler.class);

    @Override
    public void doVerb(Message message, String id) {
        byte[] bytes = message.getMessageBody();
        ByteArrayInputStream buffer = new ByteArrayInputStream(bytes);
        try {
            DataInputStream is = new DataInputStream(buffer);
            CounterMutation cm = CounterMutation.serializer().deserialize(is, message.getVersion());
            if (logger.isDebugEnabled()) {
                logger.debug("Applying forwarded " + cm);
            }
            String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getLocalAddress());
            StorageProxy.applyCounterMutationOnLeader(cm, localDataCenter).get();
            WriteResponse response = new WriteResponse(cm.getTable(), cm.key(), true);
            Message responseMessage = WriteResponse.makeWriteResponseMessage(message, response);
            MessagingService.instance().sendReply(responseMessage, id, message.getFrom());
        }
        catch (UnavailableException e) {
        }
        catch (TimeoutException e) {
        }
        catch (IOException e) {
            logger.error("Error in counter mutation", (Throwable)e);
        }
    }
}

