/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CounterCell;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletedCell;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.ExpiringCell;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.KeyIterator;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.tools.Util;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;

public class SSTableExport {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private static final String KEY_OPTION = "k";
    private static final String EXCLUDEKEY_OPTION = "x";
    private static final String ENUMERATEKEYS_OPTION = "e";
    private static final Options options = new Options();
    private static CommandLine cmd;

    private static void checkStream(PrintStream out) throws IOException {
        if (out.checkError()) {
            throw new IOException("Error writing output stream");
        }
    }

    private static void writeKey(PrintStream out, String value) {
        SSTableExport.writeJSON(out, value);
        out.print(": ");
    }

    private static List<Object> serializeAtom(OnDiskAtom atom, CFMetaData cfMetaData) {
        if (atom instanceof Cell) {
            return SSTableExport.serializeColumn((Cell)atom, cfMetaData);
        }
        assert (atom instanceof RangeTombstone);
        RangeTombstone rt = (RangeTombstone)atom;
        ArrayList<Object> serializedColumn = new ArrayList<Object>();
        serializedColumn.add(cfMetaData.comparator.getString((Composite)rt.min));
        serializedColumn.add(cfMetaData.comparator.getString((Composite)rt.max));
        serializedColumn.add(((DeletionTime)rt.data).markedForDeleteAt);
        serializedColumn.add("t");
        serializedColumn.add(((DeletionTime)rt.data).localDeletionTime);
        return serializedColumn;
    }

    private static List<Object> serializeColumn(Cell cell, CFMetaData cfMetaData) {
        CellNameType comparator = cfMetaData.comparator;
        ArrayList<Object> serializedColumn = new ArrayList<Object>();
        serializedColumn.add(comparator.getString(cell.name()));
        if (cell instanceof DeletedCell) {
            serializedColumn.add(cell.getLocalDeletionTime());
        } else {
            AbstractType<?> validator = cfMetaData.getValueValidator(cell.name());
            serializedColumn.add(validator.getString(cell.value()));
        }
        serializedColumn.add(cell.timestamp());
        if (cell instanceof DeletedCell) {
            serializedColumn.add("d");
        } else if (cell instanceof ExpiringCell) {
            serializedColumn.add(ENUMERATEKEYS_OPTION);
            serializedColumn.add(((ExpiringCell)cell).getTimeToLive());
            serializedColumn.add(cell.getLocalDeletionTime());
        } else if (cell instanceof CounterCell) {
            serializedColumn.add("c");
            serializedColumn.add(((CounterCell)cell).timestampOfLastDelete());
        }
        return serializedColumn;
    }

    private static void serializeRow(SSTableIdentityIterator row, DecoratedKey key, PrintStream out) {
        SSTableExport.serializeRow(row.getColumnFamily().deletionInfo(), row, row.getColumnFamily().metadata(), key, out);
    }

    private static void serializeRow(DeletionInfo deletionInfo, Iterator<OnDiskAtom> atoms, CFMetaData metadata, DecoratedKey key, PrintStream out) {
        out.print("{");
        SSTableExport.writeKey(out, "key");
        SSTableExport.writeJSON(out, metadata.getKeyValidator().getString(key.getKey()));
        out.print(",\n");
        if (!deletionInfo.isLive()) {
            out.print(" ");
            SSTableExport.writeKey(out, "metadata");
            out.print("{");
            SSTableExport.writeKey(out, "deletionInfo");
            SSTableExport.writeJSON(out, deletionInfo.getTopLevelDeletion());
            out.print("}");
            out.print(",\n");
        }
        out.print(" ");
        SSTableExport.writeKey(out, "cells");
        out.print("[");
        while (atoms.hasNext()) {
            SSTableExport.writeJSON(out, SSTableExport.serializeAtom(atoms.next(), metadata));
            if (!atoms.hasNext()) continue;
            out.print(",\n           ");
        }
        out.print("]");
        out.print("}");
    }

    public static void enumeratekeys(Descriptor desc, PrintStream outs, CFMetaData metadata) throws IOException {
        try (KeyIterator iter = new KeyIterator(desc);){
            DecoratedKey lastKey = null;
            while (iter.hasNext()) {
                DecoratedKey key = (DecoratedKey)iter.next();
                if (lastKey != null && lastKey.compareTo(key) > 0) {
                    throw new IOException("Key out of order! " + lastKey + " > " + key);
                }
                lastKey = key;
                outs.println(metadata.getKeyValidator().getString(key.getKey()));
                SSTableExport.checkStream(outs);
            }
        }
    }

    public static void export(Descriptor desc, PrintStream outs, Collection<String> toExport, String[] excludes, CFMetaData metadata) throws IOException {
        SSTableReader sstable = SSTableReader.open(desc);
        try (RandomAccessReader dfile = sstable.openDataReader();){
            IPartitioner partitioner = sstable.partitioner;
            if (excludes != null) {
                toExport.removeAll(Arrays.asList(excludes));
            }
            outs.println("[");
            int i = 0;
            DecoratedKey lastKey = null;
            for (String key : toExport) {
                DecoratedKey decoratedKey = partitioner.decorateKey(metadata.getKeyValidator().fromString(key));
                if (lastKey != null && lastKey.compareTo(decoratedKey) > 0) {
                    throw new IOException("Key out of order! " + lastKey + " > " + decoratedKey);
                }
                lastKey = decoratedKey;
                RowIndexEntry entry = sstable.getPosition(decoratedKey, SSTableReader.Operator.EQ);
                if (entry == null) continue;
                dfile.seek(entry.position);
                ByteBufferUtil.readWithShortLength(dfile);
                DeletionInfo deletionInfo = new DeletionInfo(DeletionTime.serializer.deserialize(dfile));
                Iterator<OnDiskAtom> atomIterator = sstable.metadata.getOnDiskIterator(dfile, sstable.descriptor.version);
                SSTableExport.checkStream(outs);
                if (i != 0) {
                    outs.println(",");
                }
                ++i;
                SSTableExport.serializeRow(deletionInfo, atomIterator, sstable.metadata, decoratedKey, outs);
            }
            outs.println("\n]");
            outs.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void export(SSTableReader reader, PrintStream outs, String[] excludes) throws IOException {
        HashSet<Object> excludeSet = new HashSet();
        if (excludes != null) {
            excludeSet = new HashSet<String>(Arrays.asList(excludes));
        }
        try (ISSTableScanner scanner = reader.getScanner();){
            outs.println("[");
            int i = 0;
            while (scanner.hasNext()) {
                SSTableIdentityIterator row = (SSTableIdentityIterator)scanner.next();
                String currentKey = row.getColumnFamily().metadata().getKeyValidator().getString(row.getKey().getKey());
                if (excludeSet.contains(currentKey)) continue;
                if (i != 0) {
                    outs.println(",");
                }
                SSTableExport.serializeRow(row, row.getKey(), outs);
                SSTableExport.checkStream(outs);
                ++i;
            }
            outs.println("\n]");
            outs.flush();
        }
    }

    public static void export(Descriptor desc, PrintStream outs, String[] excludes) throws IOException {
        SSTableExport.export(SSTableReader.open(desc), outs, excludes);
    }

    public static void export(Descriptor desc, String[] excludes) throws IOException {
        SSTableExport.export(desc, System.out, excludes);
    }

    public static void main(String[] args) throws ConfigurationException {
        System.err.println("WARNING: please note that sstable2json is now deprecated and will be removed in Cassandra 3.0. Please see https://issues.apache.org/jira/browse/CASSANDRA-9618 for details.");
        String usage = String.format("Usage: %s <sstable> [-k key [-k key [...]] -x key [-x key [...]]]%n", SSTableExport.class.getName());
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e1) {
            System.err.println(e1.getMessage());
            System.err.println(usage);
            System.exit(1);
        }
        if (cmd.getArgs().length != 1) {
            System.err.println("You must supply exactly one sstable");
            System.err.println(usage);
            System.exit(1);
        }
        Util.initDatabaseDescriptor();
        String[] keys = cmd.getOptionValues(KEY_OPTION);
        String[] excludes = cmd.getOptionValues(EXCLUDEKEY_OPTION);
        String ssTableFileName = new File(cmd.getArgs()[0]).getAbsolutePath();
        Schema.instance.loadFromDisk(false);
        Descriptor descriptor = Descriptor.fromFilename(ssTableFileName);
        if (Schema.instance.getKSMetaData(descriptor.ksname) == null) {
            System.err.println(String.format("Filename %s references to nonexistent keyspace: %s!", ssTableFileName, descriptor.ksname));
            System.exit(1);
        }
        Keyspace keyspace = Keyspace.open(descriptor.ksname);
        String baseName = descriptor.cfname;
        if (descriptor.cfname.contains(".")) {
            String[] parts = descriptor.cfname.split("\\.", 2);
            baseName = parts[0];
        }
        ColumnFamilyStore cfStore = null;
        try {
            cfStore = keyspace.getColumnFamilyStore(baseName);
        }
        catch (IllegalArgumentException e) {
            System.err.println(String.format("The provided table is not part of this cassandra keyspace: keyspace = %s, table = %s", descriptor.ksname, descriptor.cfname));
            System.exit(1);
        }
        try {
            if (cmd.hasOption(ENUMERATEKEYS_OPTION)) {
                SSTableExport.enumeratekeys(descriptor, System.out, cfStore.metadata);
            } else if (keys != null && keys.length > 0) {
                SSTableExport.export(descriptor, System.out, Arrays.asList(keys), excludes, cfStore.metadata);
            } else {
                SSTableExport.export(descriptor, excludes);
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        System.exit(0);
    }

    private static void writeJSON(PrintStream out, Object value) {
        try {
            jsonMapper.writeValue((OutputStream)out, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static {
        Option optKey = new Option(KEY_OPTION, true, "Row key");
        optKey.setArgs(500);
        options.addOption(optKey);
        Option excludeKey = new Option(EXCLUDEKEY_OPTION, true, "Excluded row key");
        excludeKey.setArgs(500);
        options.addOption(excludeKey);
        Option optEnumerate = new Option(ENUMERATEKEYS_OPTION, false, "enumerate keys only");
        options.addOption(optEnumerate);
        jsonMapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
    }
}

