/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search;

import java.lang.annotation.Annotation;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

public final class ParamConverterUtils {
    private ParamConverterUtils() {
    }

    public static <T> T getValue(Class<T> type, ParamConverterProvider provider, String value) {
        ParamConverter converter;
        if (String.class.isAssignableFrom(type)) {
            return (T)value;
        }
        if (provider != null && (converter = provider.getConverter(type, null, new Annotation[0])) != null) {
            return (T)converter.fromString(value);
        }
        throw new IllegalArgumentException(String.format("Unable to convert string '%s' to instance of class '%s': no appropriate converter provided", value, type.getName()));
    }

    public static <T> String getString(Class<T> type, ParamConverterProvider provider, T value) {
        ParamConverter converter;
        if (provider != null && (converter = provider.getConverter(type, null, new Annotation[0])) != null) {
            return converter.toString(value);
        }
        return value == null ? null : value.toString();
    }
}

