/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import java.net.URL;
import java.net.URLClassLoader;
import org.apache.cxf.jaxrs.swagger.AbstractSwaggerFeature;
import org.apache.cxf.jaxrs.swagger.OsgiSwaggerUiResolver;

public class SwaggerUiResolver {
    static final SwaggerUiResolver HELPER;

    protected SwaggerUiResolver() {
    }

    protected String findSwaggerUiRootInternal(String swaggerUiVersion) {
        try {
            ClassLoader cl = AbstractSwaggerFeature.class.getClassLoader();
            if (cl instanceof URLClassLoader) {
                String resourcesRootStart = "META-INF/resources/webjars/swagger-ui/";
                for (URL url : ((URLClassLoader)cl).getURLs()) {
                    boolean urlEndsWithJarSep;
                    String urlStr = url.toString();
                    int swaggerUiIndex = urlStr.lastIndexOf("/swagger-ui-");
                    if (swaggerUiIndex == -1 || !(urlEndsWithJarSep = urlStr.endsWith(".jar!/")) && !urlStr.endsWith(".jar")) continue;
                    int offset = urlEndsWithJarSep ? 6 : 4;
                    String version = urlStr.substring(swaggerUiIndex + 12, urlStr.length() - offset);
                    if (swaggerUiVersion != null && !swaggerUiVersion.equals(version)) continue;
                    if (!urlEndsWithJarSep) {
                        urlStr = "jar:" + urlStr + "!/";
                    }
                    return urlStr + "META-INF/resources/webjars/swagger-ui/" + version + "/";
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static String findSwaggerUiRoot(String swaggerUiVersion) {
        String root = HELPER.findSwaggerUiRootInternal(swaggerUiVersion);
        if (root == null && HELPER.getClass() != SwaggerUiResolver.class) {
            root = new SwaggerUiResolver().findSwaggerUiRootInternal(swaggerUiVersion);
        }
        return root;
    }

    static {
        SwaggerUiResolver theHelper = null;
        try {
            theHelper = new OsgiSwaggerUiResolver();
        }
        catch (Throwable ex) {
            theHelper = new SwaggerUiResolver();
        }
        HELPER = theHelper;
    }
}

