/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common;

import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.ServiceModel;

public class BaseServiceMetadata {
    public static final char COLON_SEPARATOR = ':';
    protected String serviceKey;
    protected String serviceInterfaceName;
    protected String version;
    protected volatile String group;
    private ServiceModel serviceModel;

    public static String buildServiceKey(String path, String group, String version) {
        int length = path == null ? 0 : path.length();
        length += group == null ? 0 : group.length();
        length += version == null ? 0 : version.length();
        StringBuilder buf = new StringBuilder(length += 3);
        if (StringUtils.isNotEmpty(group)) {
            buf.append(group).append('/');
        }
        buf.append(path);
        if (StringUtils.isNotEmpty(version)) {
            buf.append(':').append(version);
        }
        return buf.toString().intern();
    }

    public static String versionFromServiceKey(String serviceKey) {
        int index = serviceKey.indexOf(":");
        if (index == -1) {
            return "0.0.0";
        }
        return serviceKey.substring(index + 1);
    }

    public static String groupFromServiceKey(String serviceKey) {
        int index = serviceKey.indexOf("/");
        if (index == -1) {
            return null;
        }
        return serviceKey.substring(0, index);
    }

    public static String interfaceFromServiceKey(String serviceKey) {
        int groupIndex = serviceKey.indexOf("/");
        int versionIndex = serviceKey.indexOf(":");
        groupIndex = groupIndex == -1 ? 0 : groupIndex + 1;
        versionIndex = versionIndex == -1 ? serviceKey.length() : versionIndex;
        return serviceKey.substring(groupIndex, versionIndex);
    }

    public String getDisplayServiceKey() {
        StringBuilder serviceNameBuilder = new StringBuilder();
        serviceNameBuilder.append(this.serviceInterfaceName);
        serviceNameBuilder.append(':').append(this.version);
        return serviceNameBuilder.toString();
    }

    public static BaseServiceMetadata revertDisplayServiceKey(String displayKey) {
        String[] eles = StringUtils.split(displayKey, ':');
        if (eles == null || eles.length < 1 || eles.length > 2) {
            return new BaseServiceMetadata();
        }
        BaseServiceMetadata serviceDescriptor = new BaseServiceMetadata();
        serviceDescriptor.setServiceInterfaceName(eles[0]);
        if (eles.length == 2) {
            serviceDescriptor.setVersion(eles[1]);
        }
        return serviceDescriptor;
    }

    public static String keyWithoutGroup(String interfaceName, String version) {
        if (StringUtils.isEmpty(version)) {
            return interfaceName + ":0.0.0";
        }
        return interfaceName + ":" + version;
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public void generateServiceKey() {
        this.serviceKey = BaseServiceMetadata.buildServiceKey(this.serviceInterfaceName, this.group, this.version);
    }

    public void setServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
    }

    public String getServiceInterfaceName() {
        return this.serviceInterfaceName;
    }

    public void setServiceInterfaceName(String serviceInterfaceName) {
        this.serviceInterfaceName = serviceInterfaceName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public ServiceModel getServiceModel() {
        return this.serviceModel;
    }

    public void setServiceModel(ServiceModel serviceModel) {
        this.serviceModel = serviceModel;
    }
}

