/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.report;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MetadataReportInstance {
    private AtomicBoolean init = new AtomicBoolean(false);
    private final Map<String, MetadataReport> metadataReports = new HashMap<String, MetadataReport>();

    public void init(MetadataReportConfig config) {
        if (!this.init.compareAndSet(false, true)) {
            return;
        }
        ApplicationModel applicationModel = config.getApplicationModel();
        MetadataReportFactory metadataReportFactory = (MetadataReportFactory)applicationModel.getExtensionLoader(MetadataReportFactory.class).getAdaptiveExtension();
        URL url = config.toUrl();
        if ("metadata".equals(url.getProtocol())) {
            String protocol = url.getParameter("metadata", "dubbo");
            url = URLBuilder.from((URL)url).setProtocol(protocol).setScopeModel(config.getScopeModel()).removeParameter("metadata").build();
        }
        url = url.addParameterIfAbsent("application", applicationModel.getCurrentConfig().getName());
        String relatedRegistryId = config.getRegistry() == null ? "default" : config.getRegistry();
        MetadataReport metadataReport = metadataReportFactory.getMetadataReport(url);
        if (metadataReport != null) {
            this.metadataReports.put(relatedRegistryId, metadataReport);
        }
    }

    public Map<String, MetadataReport> getMetadataReports(boolean checked) {
        if (checked) {
            this.checkInit();
        }
        return this.metadataReports;
    }

    public MetadataReport getMetadataReport(String registryKey) {
        this.checkInit();
        MetadataReport metadataReport = this.metadataReports.get(registryKey);
        if (metadataReport == null) {
            metadataReport = this.metadataReports.values().iterator().next();
        }
        return metadataReport;
    }

    private void checkInit() {
        if (!this.init.get()) {
            throw new IllegalStateException("the metadata report was not initialized.");
        }
    }
}

