/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api;

import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.Connection;
import org.apache.dubbo.remoting.api.ConnectionManager;

public class SingleProtocolConnectionManager
implements ConnectionManager {
    private final ConcurrentMap<String, Connection> connections = PlatformDependent.newConcurrentHashMap();

    @Override
    public Connection connect(URL url) throws RemotingException {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        return this.connections.compute(url.getAddress(), (address, conn) -> {
            if (conn == null) {
                Connection created = new Connection(url);
                created.getCloseFuture().addListener(future -> this.connections.remove(address, (Object)created));
                return created;
            }
            conn.retain();
            return conn;
        });
    }

    @Override
    public void forEachConnection(Consumer<Connection> connectionConsumer) {
        this.connections.values().forEach(connectionConsumer);
    }
}

