/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.api.common.accumulators.AccumulatorHelper;
import org.apache.flink.client.cli.CancelOptions;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.client.cli.DefaultCLI;
import org.apache.flink.client.cli.InfoOptions;
import org.apache.flink.client.cli.LegacyCLI;
import org.apache.flink.client.cli.ListOptions;
import org.apache.flink.client.cli.ProgramOptions;
import org.apache.flink.client.cli.RunOptions;
import org.apache.flink.client.cli.SavepointOptions;
import org.apache.flink.client.cli.StopOptions;
import org.apache.flink.client.deployment.ClusterDescriptor;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.client.program.ProgramMissingJobException;
import org.apache.flink.client.program.ProgramParametrizationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.costs.DefaultCostEstimator;
import org.apache.flink.optimizer.plan.FlinkPlan;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.StreamingPlan;
import org.apache.flink.optimizer.plandump.PlanJSONDumpGenerator;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.FiniteDuration;

public class CliFrontend {
    private static final Logger LOG = LoggerFactory.getLogger(CliFrontend.class);
    private static final String ACTION_RUN = "run";
    private static final String ACTION_INFO = "info";
    private static final String ACTION_LIST = "list";
    private static final String ACTION_CANCEL = "cancel";
    private static final String ACTION_STOP = "stop";
    private static final String ACTION_SAVEPOINT = "savepoint";
    private static final String ACTION_MODIFY = "modify";
    private static final String CONFIG_DIRECTORY_FALLBACK_1 = "../conf";
    private static final String CONFIG_DIRECTORY_FALLBACK_2 = "conf";
    private final Configuration configuration;
    private final List<CustomCommandLine<?>> customCommandLines;
    private final Options customCommandLineOptions;
    private final FiniteDuration clientTimeout;
    private final int defaultParallelism;
    private final boolean isNewMode;

    public CliFrontend(Configuration configuration, List<CustomCommandLine<?>> customCommandLines) throws Exception {
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.customCommandLines = (List)Preconditions.checkNotNull(customCommandLines);
        try {
            FileSystem.initialize((Configuration)this.configuration);
        }
        catch (IOException e) {
            throw new Exception("Error while setting the default filesystem scheme from configuration.", e);
        }
        this.customCommandLineOptions = new Options();
        for (CustomCommandLine<?> customCommandLine : customCommandLines) {
            customCommandLine.addGeneralOptions(this.customCommandLineOptions);
            customCommandLine.addRunOptions(this.customCommandLineOptions);
        }
        this.clientTimeout = AkkaUtils.getClientTimeout((Configuration)this.configuration);
        this.defaultParallelism = configuration.getInteger(CoreOptions.DEFAULT_PARALLELISM);
        this.isNewMode = "new".equalsIgnoreCase(configuration.getString(CoreOptions.MODE));
    }

    public Configuration getConfiguration() {
        Configuration copiedConfiguration = new Configuration();
        copiedConfiguration.addAll(this.configuration);
        return copiedConfiguration;
    }

    public Options getCustomCommandLineOptions() {
        return this.customCommandLineOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(String[] args) throws Exception {
        PackagedProgram program;
        LOG.info("Running 'run' command.");
        Options commandOptions = CliFrontendParser.getRunCommandOptions();
        Options commandLineOptions = CliFrontendParser.mergeOptions(commandOptions, this.customCommandLineOptions);
        CommandLine commandLine = CliFrontendParser.parse(commandLineOptions, args, true);
        RunOptions runOptions = new RunOptions(commandLine);
        if (runOptions.isPrintHelp()) {
            CliFrontendParser.printHelpForRun(this.customCommandLines);
            return;
        }
        if (runOptions.getJarFilePath() == null) {
            throw new CliArgsException("The program JAR file was not specified.");
        }
        try {
            LOG.info("Building program from JAR file");
            program = this.buildProgram(runOptions);
        }
        catch (FileNotFoundException e) {
            throw new CliArgsException("Could not build the program from JAR file.", e);
        }
        CustomCommandLine<?> customCommandLine = this.getActiveCustomCommandLine(commandLine);
        try {
            this.runProgram(customCommandLine, commandLine, runOptions, program);
        }
        finally {
            program.deleteExtractedLibraries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void runProgram(CustomCommandLine<T> customCommandLine, CommandLine commandLine, RunOptions runOptions, PackagedProgram program) throws ProgramInvocationException, FlinkException {
        block27: {
            ClusterDescriptor<T> clusterDescriptor = customCommandLine.createClusterDescriptor(commandLine);
            try {
                ClusterClient<T> client;
                T clusterId = customCommandLine.getClusterId(commandLine);
                if (this.isNewMode && clusterId == null && runOptions.getDetachedMode()) {
                    int parallelism = runOptions.getParallelism() == -1 ? this.defaultParallelism : runOptions.getParallelism();
                    JobGraph jobGraph = PackagedProgramUtils.createJobGraph(program, this.configuration, parallelism);
                    ClusterSpecification clusterSpecification = customCommandLine.getClusterSpecification(commandLine);
                    ClusterClient<T> client2 = clusterDescriptor.deployJobCluster(clusterSpecification, jobGraph, runOptions.getDetachedMode());
                    CliFrontend.logAndSysout("Job has been submitted with JobID " + jobGraph.getJobID());
                    try {
                        client2.shutdown();
                    }
                    catch (Exception e) {
                        LOG.info("Could not properly shut down the client.", (Throwable)e);
                    }
                    break block27;
                }
                if (clusterId != null) {
                    client = clusterDescriptor.retrieve(clusterId);
                } else {
                    ClusterSpecification clusterSpecification = customCommandLine.getClusterSpecification(commandLine);
                    client = clusterDescriptor.deploySessionCluster(clusterSpecification);
                }
                try {
                    client.setPrintStatusDuringExecution(runOptions.getStdoutLogging());
                    client.setDetached(runOptions.getDetachedMode());
                    LOG.debug("Client slots is set to {}", (Object)client.getMaxSlots());
                    LOG.debug("{}", (Object)runOptions.getSavepointRestoreSettings());
                    int userParallelism = runOptions.getParallelism();
                    LOG.debug("User parallelism is set to {}", (Object)userParallelism);
                    if (client.getMaxSlots() != -1 && userParallelism == -1) {
                        CliFrontend.logAndSysout("Using the parallelism provided by the remote cluster (" + client.getMaxSlots() + "). To use another parallelism, set it at the ./bin/flink client.");
                        userParallelism = client.getMaxSlots();
                    } else if (-1 == userParallelism) {
                        userParallelism = this.defaultParallelism;
                    }
                    this.executeProgram(program, client, userParallelism);
                }
                finally {
                    if (clusterId == null && !client.isDetached()) {
                        try {
                            client.shutDownCluster();
                        }
                        catch (Exception e) {
                            LOG.info("Could not properly terminate the Flink cluster.", (Throwable)e);
                        }
                    }
                    try {
                        client.shutdown();
                    }
                    catch (Exception e) {
                        LOG.info("Could not properly shut down the client.", (Throwable)e);
                    }
                }
            }
            finally {
                try {
                    clusterDescriptor.close();
                }
                catch (Exception e) {
                    LOG.info("Could not properly close the cluster descriptor.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void info(String[] args) throws CliArgsException, FileNotFoundException, ProgramInvocationException {
        LOG.info("Running 'info' command.");
        Options commandOptions = CliFrontendParser.getInfoCommandOptions();
        CommandLine commandLine = CliFrontendParser.parse(commandOptions, args, true);
        InfoOptions infoOptions = new InfoOptions(commandLine);
        if (infoOptions.isPrintHelp()) {
            CliFrontendParser.printHelpForInfo();
            return;
        }
        if (infoOptions.getJarFilePath() == null) {
            throw new CliArgsException("The program JAR file was not specified.");
        }
        LOG.info("Building program from JAR file");
        PackagedProgram program = this.buildProgram(infoOptions);
        try {
            int parallelism = infoOptions.getParallelism();
            if (-1 == parallelism) {
                parallelism = this.defaultParallelism;
            }
            LOG.info("Creating program plan dump");
            Optimizer compiler = new Optimizer(new DataStatistics(), (CostEstimator)new DefaultCostEstimator(), this.configuration);
            FlinkPlan flinkPlan = ClusterClient.getOptimizedPlan(compiler, program, parallelism);
            String jsonPlan = null;
            if (flinkPlan instanceof OptimizedPlan) {
                jsonPlan = new PlanJSONDumpGenerator().getOptimizerPlanAsJSON((OptimizedPlan)flinkPlan);
            } else if (flinkPlan instanceof StreamingPlan) {
                jsonPlan = ((StreamingPlan)flinkPlan).getStreamingPlanAsJSON();
            }
            if (jsonPlan != null) {
                System.out.println("----------------------- Execution Plan -----------------------");
                System.out.println(jsonPlan);
                System.out.println("--------------------------------------------------------------");
            } else {
                System.out.println("JSON plan could not be generated.");
            }
            String description = program.getDescription();
            if (description != null) {
                System.out.println();
                System.out.println(description);
            } else {
                System.out.println();
                System.out.println("No description provided.");
            }
        }
        finally {
            program.deleteExtractedLibraries();
        }
    }

    protected void list(String[] args) throws Exception {
        boolean showAll;
        boolean showScheduled;
        boolean showRunning;
        LOG.info("Running 'list' command.");
        Options commandOptions = CliFrontendParser.getListCommandOptions();
        Options commandLineOptions = CliFrontendParser.mergeOptions(commandOptions, this.customCommandLineOptions);
        CommandLine commandLine = CliFrontendParser.parse(commandLineOptions, args, false);
        ListOptions listOptions = new ListOptions(commandLine);
        if (listOptions.isPrintHelp()) {
            CliFrontendParser.printHelpForList(this.customCommandLines);
            return;
        }
        if (!(listOptions.showRunning() || listOptions.showScheduled() || listOptions.showAll())) {
            showRunning = true;
            showScheduled = true;
            showAll = false;
        } else {
            showRunning = listOptions.showRunning();
            showScheduled = listOptions.showScheduled();
            showAll = listOptions.showAll();
        }
        CustomCommandLine<?> activeCommandLine = this.getActiveCustomCommandLine(commandLine);
        this.runClusterAction(activeCommandLine, commandLine, clusterClient -> this.listJobs(clusterClient, showRunning, showScheduled, showAll));
    }

    private <T> void listJobs(ClusterClient<T> clusterClient, boolean showRunning, boolean showScheduled, boolean showAll) throws FlinkException {
        Collection<JobStatusMessage> jobDetails;
        try {
            CompletableFuture<Collection<JobStatusMessage>> jobDetailsFuture = clusterClient.listJobs();
            CliFrontend.logAndSysout("Waiting for response...");
            jobDetails = jobDetailsFuture.get();
        }
        catch (Exception e) {
            Throwable cause = ExceptionUtils.stripExecutionException((Throwable)e);
            throw new FlinkException("Failed to retrieve job list.", cause);
        }
        LOG.info("Successfully retrieved list of jobs");
        ArrayList<JobStatusMessage> runningJobs = new ArrayList<JobStatusMessage>();
        ArrayList<JobStatusMessage> scheduledJobs = new ArrayList<JobStatusMessage>();
        ArrayList<JobStatusMessage> terminatedJobs = new ArrayList<JobStatusMessage>();
        jobDetails.forEach(details -> {
            if (details.getJobState() == JobStatus.CREATED) {
                scheduledJobs.add((JobStatusMessage)details);
            } else if (!details.getJobState().isGloballyTerminalState()) {
                runningJobs.add((JobStatusMessage)details);
            } else {
                terminatedJobs.add((JobStatusMessage)details);
            }
        });
        if (showRunning || showAll) {
            if (runningJobs.size() == 0) {
                System.out.println("No running jobs.");
            } else {
                System.out.println("------------------ Running/Restarting Jobs -------------------");
                CliFrontend.printJobStatusMessages(runningJobs);
                System.out.println("--------------------------------------------------------------");
            }
        }
        if (showScheduled || showAll) {
            if (scheduledJobs.size() == 0) {
                System.out.println("No scheduled jobs.");
            } else {
                System.out.println("----------------------- Scheduled Jobs -----------------------");
                CliFrontend.printJobStatusMessages(scheduledJobs);
                System.out.println("--------------------------------------------------------------");
            }
        }
        if (showAll && terminatedJobs.size() != 0) {
            System.out.println("---------------------- Terminated Jobs -----------------------");
            CliFrontend.printJobStatusMessages(terminatedJobs);
            System.out.println("--------------------------------------------------------------");
        }
    }

    private static void printJobStatusMessages(List<JobStatusMessage> jobs) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        Comparator startTimeComparator = (o1, o2) -> (int)(o1.getStartTime() - o2.getStartTime());
        Comparator statusComparator = (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(((JobStatus)o1.getKey()).toString(), ((JobStatus)o2.getKey()).toString());
        Map<JobStatus, List<JobStatusMessage>> jobsByState = jobs.stream().collect(Collectors.groupingBy(JobStatusMessage::getJobState));
        jobsByState.entrySet().stream().sorted(statusComparator).map(Map.Entry::getValue).flatMap(Collection::stream).sorted(startTimeComparator).forEachOrdered(job -> System.out.println(dateFormat.format(new Date(job.getStartTime())) + " : " + job.getJobId() + " : " + job.getJobName() + " (" + job.getJobState() + ")"));
    }

    protected void stop(String[] args) throws Exception {
        LOG.info("Running 'stop' command.");
        Options commandOptions = CliFrontendParser.getStopCommandOptions();
        Options commandLineOptions = CliFrontendParser.mergeOptions(commandOptions, this.customCommandLineOptions);
        CommandLine commandLine = CliFrontendParser.parse(commandLineOptions, args, false);
        StopOptions stopOptions = new StopOptions(commandLine);
        if (stopOptions.isPrintHelp()) {
            CliFrontendParser.printHelpForStop(this.customCommandLines);
            return;
        }
        String[] stopArgs = stopOptions.getArgs();
        if (stopArgs.length <= 0) {
            throw new CliArgsException("Missing JobID");
        }
        String jobIdString = stopArgs[0];
        JobID jobId = this.parseJobId(jobIdString);
        CustomCommandLine<?> activeCommandLine = this.getActiveCustomCommandLine(commandLine);
        CliFrontend.logAndSysout("Stopping job " + jobId + '.');
        this.runClusterAction(activeCommandLine, commandLine, clusterClient -> {
            try {
                clusterClient.stop(jobId);
            }
            catch (Exception e) {
                throw new FlinkException("Could not stop the job " + jobId + '.', (Throwable)e);
            }
        });
        CliFrontend.logAndSysout("Stopped job " + jobId + '.');
    }

    protected void cancel(String[] args) throws Exception {
        LOG.info("Running 'cancel' command.");
        Options commandOptions = CliFrontendParser.getCancelCommandOptions();
        Options commandLineOptions = CliFrontendParser.mergeOptions(commandOptions, this.customCommandLineOptions);
        CommandLine commandLine = CliFrontendParser.parse(commandLineOptions, args, false);
        CancelOptions cancelOptions = new CancelOptions(commandLine);
        if (cancelOptions.isPrintHelp()) {
            CliFrontendParser.printHelpForCancel(this.customCommandLines);
            return;
        }
        CustomCommandLine<?> activeCommandLine = this.getActiveCustomCommandLine(commandLine);
        String[] cleanedArgs = cancelOptions.getArgs();
        if (cancelOptions.isWithSavepoint()) {
            String targetDirectory;
            JobID jobId;
            if (cleanedArgs.length > 0) {
                jobId = this.parseJobId(cleanedArgs[0]);
                targetDirectory = cancelOptions.getSavepointTargetDirectory();
            } else {
                jobId = this.parseJobId(cancelOptions.getSavepointTargetDirectory());
                targetDirectory = null;
            }
            if (targetDirectory == null) {
                CliFrontend.logAndSysout("Cancelling job " + jobId + " with savepoint to default savepoint directory.");
            } else {
                CliFrontend.logAndSysout("Cancelling job " + jobId + " with savepoint to " + targetDirectory + '.');
            }
            this.runClusterAction(activeCommandLine, commandLine, clusterClient -> {
                String savepointPath;
                try {
                    savepointPath = clusterClient.cancelWithSavepoint(jobId, targetDirectory);
                }
                catch (Exception e) {
                    throw new FlinkException("Could not cancel job " + jobId + '.', (Throwable)e);
                }
                CliFrontend.logAndSysout("Cancelled job " + jobId + ". Savepoint stored in " + savepointPath + '.');
            });
        } else {
            if (cleanedArgs.length <= 0) {
                throw new CliArgsException("Missing JobID. Specify a JobID to cancel a job.");
            }
            JobID jobId = this.parseJobId(cleanedArgs[0]);
            CliFrontend.logAndSysout("Cancelling job " + jobId + '.');
            this.runClusterAction(activeCommandLine, commandLine, clusterClient -> {
                try {
                    clusterClient.cancel(jobId);
                }
                catch (Exception e) {
                    throw new FlinkException("Could not cancel job " + jobId + '.', (Throwable)e);
                }
            });
            CliFrontend.logAndSysout("Cancelled job " + jobId + '.');
        }
    }

    protected void savepoint(String[] args) throws Exception {
        LOG.info("Running 'savepoint' command.");
        Options commandOptions = CliFrontendParser.getSavepointCommandOptions();
        Options commandLineOptions = CliFrontendParser.mergeOptions(commandOptions, this.customCommandLineOptions);
        CommandLine commandLine = CliFrontendParser.parse(commandLineOptions, args, false);
        SavepointOptions savepointOptions = new SavepointOptions(commandLine);
        if (savepointOptions.isPrintHelp()) {
            CliFrontendParser.printHelpForSavepoint(this.customCommandLines);
            return;
        }
        CustomCommandLine<?> activeCommandLine = this.getActiveCustomCommandLine(commandLine);
        if (savepointOptions.isDispose()) {
            this.runClusterAction(activeCommandLine, commandLine, clusterClient -> this.disposeSavepoint(clusterClient, savepointOptions.getSavepointPath()));
        } else {
            String[] cleanedArgs = savepointOptions.getArgs();
            if (cleanedArgs.length < 1) {
                throw new CliArgsException("Missing JobID. Specify a Job ID to trigger a savepoint.");
            }
            String jobIdString = cleanedArgs[0];
            JobID jobId = this.parseJobId(jobIdString);
            String savepointDirectory = cleanedArgs.length >= 2 ? cleanedArgs[1] : null;
            if (cleanedArgs.length >= 3) {
                CliFrontend.logAndSysout("Provided more arguments than required. Ignoring not needed arguments.");
            }
            this.runClusterAction(activeCommandLine, commandLine, clusterClient -> this.triggerSavepoint(clusterClient, jobId, savepointDirectory));
        }
    }

    private String triggerSavepoint(ClusterClient<?> clusterClient, JobID jobId, String savepointDirectory) throws FlinkException {
        String savepointPath;
        CliFrontend.logAndSysout("Triggering savepoint for job " + jobId + '.');
        CompletableFuture<String> savepointPathFuture = clusterClient.triggerSavepoint(jobId, savepointDirectory);
        CliFrontend.logAndSysout("Waiting for response...");
        try {
            savepointPath = savepointPathFuture.get();
        }
        catch (Exception e) {
            Throwable cause = ExceptionUtils.stripExecutionException((Throwable)e);
            throw new FlinkException("Triggering a savepoint for the job " + jobId + " failed.", cause);
        }
        CliFrontend.logAndSysout("Savepoint completed. Path: " + savepointPath);
        CliFrontend.logAndSysout("You can resume your program from this savepoint with the run command.");
        return savepointPath;
    }

    private void disposeSavepoint(ClusterClient<?> clusterClient, String savepointPath) throws FlinkException {
        Preconditions.checkNotNull((Object)savepointPath, (String)"Missing required argument: savepoint path. Usage: bin/flink savepoint -d <savepoint-path>");
        CliFrontend.logAndSysout("Disposing savepoint '" + savepointPath + "'.");
        CompletableFuture<Acknowledge> disposeFuture = clusterClient.disposeSavepoint(savepointPath);
        CliFrontend.logAndSysout("Waiting for response...");
        try {
            disposeFuture.get(this.clientTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new FlinkException("Disposing the savepoint '" + savepointPath + "' failed.", (Throwable)e);
        }
        CliFrontend.logAndSysout("Savepoint '" + savepointPath + "' disposed.");
    }

    protected void modify(String[] args) throws CliArgsException, FlinkException {
        int newParallelism;
        String[] modifyArgs;
        LOG.info("Running 'modify' command.");
        Options commandOptions = CliFrontendParser.getModifyOptions();
        Options commandLineOptions = CliFrontendParser.mergeOptions(commandOptions, this.customCommandLineOptions);
        CommandLine commandLine = CliFrontendParser.parse(commandLineOptions, args, false);
        if (commandLine.hasOption(CliFrontendParser.HELP_OPTION.getOpt())) {
            CliFrontendParser.printHelpForModify(this.customCommandLines);
        }
        if ((modifyArgs = commandLine.getArgs()).length <= 0) {
            throw new CliArgsException("Missing JobId");
        }
        JobID jobId = this.parseJobId(modifyArgs[0]);
        if (commandLine.hasOption(CliFrontendParser.MODIFY_PARALLELISM_OPTION.getOpt())) {
            try {
                newParallelism = Integer.parseInt(commandLine.getOptionValue(CliFrontendParser.MODIFY_PARALLELISM_OPTION.getOpt()));
            }
            catch (NumberFormatException e) {
                throw new CliArgsException("Could not parse the parallelism which is supposed to be an integer.", e);
            }
        } else {
            throw new CliArgsException("Missing new parallelism.");
        }
        CustomCommandLine<?> activeCommandLine = this.getActiveCustomCommandLine(commandLine);
        CliFrontend.logAndSysout("Modify job " + jobId + '.');
        this.runClusterAction(activeCommandLine, commandLine, clusterClient -> {
            CompletableFuture<Acknowledge> rescaleFuture = clusterClient.rescaleJob(jobId, newParallelism);
            try {
                rescaleFuture.get();
            }
            catch (Exception e) {
                throw new FlinkException("Could not rescale job " + jobId + '.', ExceptionUtils.stripExecutionException((Throwable)e));
            }
            CliFrontend.logAndSysout("Rescaled job " + jobId + ". Its new parallelism is " + newParallelism + '.');
        });
    }

    protected void executeProgram(PackagedProgram program, ClusterClient<?> client, int parallelism) throws ProgramMissingJobException, ProgramInvocationException {
        CliFrontend.logAndSysout("Starting execution of program");
        JobSubmissionResult result = client.run(program, parallelism);
        if (null == result) {
            throw new ProgramMissingJobException("No JobSubmissionResult returned, please make sure you called ExecutionEnvironment.execute()");
        }
        if (result.isJobExecutionResult()) {
            CliFrontend.logAndSysout("Program execution finished");
            JobExecutionResult execResult = result.getJobExecutionResult();
            System.out.println("Job with JobID " + execResult.getJobID() + " has finished.");
            System.out.println("Job Runtime: " + execResult.getNetRuntime() + " ms");
            Map accumulatorsResult = execResult.getAllAccumulatorResults();
            if (accumulatorsResult.size() > 0) {
                System.out.println("Accumulator Results: ");
                System.out.println(AccumulatorHelper.getResultsFormatted((Map)accumulatorsResult));
            }
        } else {
            CliFrontend.logAndSysout("Job has been submitted with JobID " + result.getJobID());
        }
    }

    protected PackagedProgram buildProgram(ProgramOptions options) throws FileNotFoundException, ProgramInvocationException {
        String[] programArgs = options.getProgramArgs();
        String jarFilePath = options.getJarFilePath();
        List<URL> classpaths = options.getClasspaths();
        if (jarFilePath == null) {
            throw new IllegalArgumentException("The program JAR file was not specified.");
        }
        File jarFile = new File(jarFilePath);
        if (!jarFile.exists()) {
            throw new FileNotFoundException("JAR file does not exist: " + jarFile);
        }
        if (!jarFile.isFile()) {
            throw new FileNotFoundException("JAR file is not a file: " + jarFile);
        }
        String entryPointClass = options.getEntryPointClassName();
        PackagedProgram program = entryPointClass == null ? new PackagedProgram(jarFile, classpaths, programArgs) : new PackagedProgram(jarFile, classpaths, entryPointClass, programArgs);
        program.setSavepointRestoreSettings(options.getSavepointRestoreSettings());
        return program;
    }

    private static int handleArgException(CliArgsException e) {
        LOG.error("Invalid command line arguments.", (Throwable)e);
        System.out.println(e.getMessage());
        System.out.println();
        System.out.println("Use the help option (-h or --help) to get help on the command.");
        return 1;
    }

    private static int handleParametrizationException(ProgramParametrizationException e) {
        LOG.error("Program has not been parametrized properly.", (Throwable)e);
        System.err.println(e.getMessage());
        return 1;
    }

    private static int handleMissingJobException() {
        System.err.println();
        System.err.println("The program didn't contain a Flink job. Perhaps you forgot to call execute() on the execution environment.");
        return 1;
    }

    private static int handleError(Throwable t) {
        LOG.error("Error while running the command.", t);
        System.err.println();
        System.err.println("------------------------------------------------------------");
        System.err.println(" The program finished with the following exception:");
        System.err.println();
        if (t.getCause() instanceof InvalidProgramException) {
            StackTraceElement[] trace;
            System.err.println(t.getCause().getMessage());
            for (StackTraceElement ele : trace = t.getCause().getStackTrace()) {
                System.err.println("\t" + ele);
                if (!ele.getMethodName().equals("main")) {
                    continue;
                }
                break;
            }
        } else {
            t.printStackTrace();
        }
        return 1;
    }

    private static void logAndSysout(String message) {
        LOG.info(message);
        System.out.println(message);
    }

    private JobID parseJobId(String jobIdString) throws CliArgsException {
        JobID jobId;
        try {
            jobId = JobID.fromHexString((String)jobIdString);
        }
        catch (IllegalArgumentException e) {
            throw new CliArgsException(e.getMessage());
        }
        return jobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void runClusterAction(CustomCommandLine<T> activeCommandLine, CommandLine commandLine, ClusterAction<T> clusterAction) throws FlinkException {
        ClusterDescriptor<T> clusterDescriptor = activeCommandLine.createClusterDescriptor(commandLine);
        T clusterId = activeCommandLine.getClusterId(commandLine);
        if (clusterId == null) {
            throw new FlinkException("No cluster id was specified. Please specify a cluster to which you would like to connect.");
        }
        try {
            ClusterClient<T> clusterClient = clusterDescriptor.retrieve(clusterId);
            try {
                clusterAction.runAction(clusterClient);
            }
            finally {
                try {
                    clusterClient.shutdown();
                }
                catch (Exception e) {
                    LOG.info("Could not properly shut down the cluster client.", (Throwable)e);
                }
            }
        }
        finally {
            try {
                clusterDescriptor.close();
            }
            catch (Exception e) {
                LOG.info("Could not properly close the cluster descriptor.", (Throwable)e);
            }
        }
    }

    public int parseParameters(String[] args) {
        if (args.length < 1) {
            CliFrontendParser.printHelp(this.customCommandLines);
            System.out.println("Please specify an action.");
            return 1;
        }
        String action = args[0];
        String[] params = Arrays.copyOfRange(args, 1, args.length);
        try {
            switch (action) {
                case "run": {
                    this.run(params);
                    return 0;
                }
                case "list": {
                    this.list(params);
                    return 0;
                }
                case "info": {
                    this.info(params);
                    return 0;
                }
                case "cancel": {
                    this.cancel(params);
                    return 0;
                }
                case "stop": {
                    this.stop(params);
                    return 0;
                }
                case "savepoint": {
                    this.savepoint(params);
                    return 0;
                }
                case "modify": {
                    this.modify(params);
                    return 0;
                }
                case "-h": 
                case "--help": {
                    CliFrontendParser.printHelp(this.customCommandLines);
                    return 0;
                }
                case "-v": 
                case "--version": {
                    String version = EnvironmentInformation.getVersion();
                    String commitID = EnvironmentInformation.getRevisionInformation().commitId;
                    System.out.print("Version: " + version);
                    System.out.println(commitID.equals("<unknown>") ? "" : ", Commit ID: " + commitID);
                    return 0;
                }
            }
            System.out.printf("\"%s\" is not a valid action.\n", action);
            System.out.println();
            System.out.println("Valid actions are \"run\", \"list\", \"info\", \"savepoint\", \"stop\", or \"cancel\".");
            System.out.println();
            System.out.println("Specify the version option (-v or --version) to print Flink version.");
            System.out.println();
            System.out.println("Specify the help option (-h or --help) to get help on the command.");
            return 1;
        }
        catch (CliArgsException ce) {
            return CliFrontend.handleArgException(ce);
        }
        catch (ProgramParametrizationException ppe) {
            return CliFrontend.handleParametrizationException(ppe);
        }
        catch (ProgramMissingJobException pmje) {
            return CliFrontend.handleMissingJobException();
        }
        catch (Exception e) {
            return CliFrontend.handleError(e);
        }
    }

    public static void main(String[] args) {
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)"Command Line Client", (String[])args);
        String configurationDirectory = CliFrontend.getConfigurationDirectoryFromEnv();
        Configuration configuration = GlobalConfiguration.loadConfiguration((String)configurationDirectory);
        List<CustomCommandLine<?>> customCommandLines = CliFrontend.loadCustomCommandLines(configuration, configurationDirectory);
        try {
            CliFrontend cli = new CliFrontend(configuration, customCommandLines);
            SecurityUtils.install((SecurityConfiguration)new SecurityConfiguration(cli.configuration));
            int retCode = (Integer)SecurityUtils.getInstalledContext().runSecured(() -> cli.parseParameters(args));
            System.exit(retCode);
        }
        catch (Throwable t) {
            LOG.error("Fatal error while running command line interface.", t);
            t.printStackTrace();
            System.exit(31);
        }
    }

    public static String getConfigurationDirectoryFromEnv() {
        String location = System.getenv("FLINK_CONF_DIR");
        if (location != null) {
            if (new File(location).exists()) {
                return location;
            }
            throw new RuntimeException("The configuration directory '" + location + "', specified in the '" + "FLINK_CONF_DIR" + "' environment variable, does not exist.");
        }
        if (new File(CONFIG_DIRECTORY_FALLBACK_1).exists()) {
            location = CONFIG_DIRECTORY_FALLBACK_1;
        } else if (new File(CONFIG_DIRECTORY_FALLBACK_2).exists()) {
            location = CONFIG_DIRECTORY_FALLBACK_2;
        } else {
            throw new RuntimeException("The configuration directory was not specified. Please specify the directory containing the configuration file through the 'FLINK_CONF_DIR' environment variable.");
        }
        return location;
    }

    public static void setJobManagerAddressInConfig(Configuration config, InetSocketAddress address) {
        config.setString(JobManagerOptions.ADDRESS, address.getHostString());
        config.setInteger(JobManagerOptions.PORT, address.getPort());
        config.setString(RestOptions.ADDRESS, address.getHostString());
        config.setInteger(RestOptions.PORT, address.getPort());
    }

    public static List<CustomCommandLine<?>> loadCustomCommandLines(Configuration configuration, String configurationDirectory) {
        ArrayList customCommandLines = new ArrayList(2);
        String flinkYarnSessionCLI = "org.apache.flink.yarn.cli.FlinkYarnSessionCli";
        try {
            customCommandLines.add(CliFrontend.loadCustomCommandLine("org.apache.flink.yarn.cli.FlinkYarnSessionCli", configuration, configurationDirectory, "y", "yarn"));
        }
        catch (Exception | NoClassDefFoundError e) {
            LOG.warn("Could not load CLI class {}.", (Object)"org.apache.flink.yarn.cli.FlinkYarnSessionCli", (Object)e);
        }
        if (configuration.getString(CoreOptions.MODE).equalsIgnoreCase("new")) {
            customCommandLines.add(new DefaultCLI(configuration));
        } else {
            customCommandLines.add(new LegacyCLI(configuration));
        }
        return customCommandLines;
    }

    public CustomCommandLine<?> getActiveCustomCommandLine(CommandLine commandLine) {
        for (CustomCommandLine<?> cli : this.customCommandLines) {
            if (!cli.isActive(commandLine)) continue;
            return cli;
        }
        throw new IllegalStateException("No command-line ran.");
    }

    private static CustomCommandLine<?> loadCustomCommandLine(String className, Object ... params) throws IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException, NoSuchMethodException {
        Class<CustomCommandLine> customCliClass = Class.forName(className).asSubclass(CustomCommandLine.class);
        Class[] types = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            Preconditions.checkNotNull((Object)params[i], (String)"Parameters for custom command-lines may not be null.");
            types[i] = params[i].getClass();
        }
        Constructor<CustomCommandLine> constructor = customCliClass.getConstructor(types);
        return constructor.newInstance(params);
    }

    @FunctionalInterface
    private static interface ClusterAction<T> {
        public void runAction(ClusterClient<T> var1) throws FlinkException;
    }
}

