/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.net.URISyntaxException;
import java.net.URL;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.Plan;
import org.apache.flink.client.program.JobWithJars;
import org.apache.flink.client.program.OptimizerPlanEnvironment;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.costs.DefaultCostEstimator;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.StreamingPlan;
import org.apache.flink.optimizer.plantranslate.JobGraphGenerator;
import org.apache.flink.runtime.jobgraph.JobGraph;

public class PackagedProgramUtils {
    public static JobGraph createJobGraph(PackagedProgram packagedProgram, Configuration configuration, int defaultParallelism, JobID jobID) throws ProgramInvocationException {
        JobGraph jobGraph;
        OptimizedPlan flinkPlan;
        Thread.currentThread().setContextClassLoader(packagedProgram.getUserCodeClassLoader());
        Optimizer optimizer = new Optimizer(new DataStatistics(), (CostEstimator)new DefaultCostEstimator(), configuration);
        if (packagedProgram.isUsingProgramEntryPoint()) {
            JobWithJars jobWithJars = packagedProgram.getPlanWithJars();
            Plan plan = jobWithJars.getPlan();
            if (plan.getDefaultParallelism() <= 0) {
                plan.setDefaultParallelism(defaultParallelism);
            }
            flinkPlan = optimizer.compile(jobWithJars.getPlan());
        } else if (packagedProgram.isUsingInteractiveMode()) {
            OptimizerPlanEnvironment optimizerPlanEnvironment = new OptimizerPlanEnvironment(optimizer);
            optimizerPlanEnvironment.setParallelism(defaultParallelism);
            flinkPlan = optimizerPlanEnvironment.getOptimizedPlan(packagedProgram);
        } else {
            throw new ProgramInvocationException("PackagedProgram does not have a valid invocation mode.");
        }
        if (flinkPlan instanceof StreamingPlan) {
            jobGraph = ((StreamingPlan)flinkPlan).getJobGraph(jobID);
            jobGraph.setSavepointRestoreSettings(packagedProgram.getSavepointSettings());
        } else {
            JobGraphGenerator jobGraphGenerator = new JobGraphGenerator(configuration);
            jobGraph = jobGraphGenerator.compileJobGraph(flinkPlan, jobID);
        }
        for (URL url : packagedProgram.getAllLibraries()) {
            try {
                jobGraph.addJar(new Path(url.toURI()));
            }
            catch (URISyntaxException e) {
                throw new ProgramInvocationException("Invalid URL for jar file: " + url + '.', jobGraph.getJobID(), e);
            }
        }
        jobGraph.setClasspaths(packagedProgram.getClasspaths());
        return jobGraph;
    }

    public static JobGraph createJobGraph(PackagedProgram packagedProgram, Configuration configuration, int defaultParallelism) throws ProgramInvocationException {
        return PackagedProgramUtils.createJobGraph(packagedProgram, configuration, defaultParallelism, null);
    }

    private PackagedProgramUtils() {
    }
}

