/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.drivers.parameter;

import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.client.program.ProgramParametrizationException;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAlgorithm;
import org.apache.flink.graph.drivers.parameter.Parameter;
import org.apache.flink.graph.drivers.parameter.ParameterizedBase;
import org.apache.flink.types.NullValue;

public class Simplify
implements Parameter<Ordering> {
    private Ordering value;

    public Simplify(ParameterizedBase owner) {
        owner.addParameter(this);
    }

    @Override
    public String getUsage() {
        return "[--simplify <directed | undirected [--clip_and_flip]>] ";
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public void configure(ParameterTool parameterTool) {
        String ordering = parameterTool.get("simplify");
        if (ordering == null) {
            this.value = Ordering.NONE;
        } else {
            switch (ordering.toLowerCase()) {
                case "directed": {
                    this.value = Ordering.DIRECTED;
                    break;
                }
                case "undirected": {
                    this.value = parameterTool.has("clip_and_flip") ? Ordering.UNDIRECTED_CLIP_AND_FLIP : Ordering.UNDIRECTED;
                    break;
                }
                default: {
                    throw new ProgramParametrizationException("Expected 'directed' or 'undirected' ordering but received '" + ordering + "'");
                }
            }
        }
    }

    @Override
    public Ordering getValue() {
        return this.value;
    }

    public <T extends Comparable<T>> Graph<T, NullValue, NullValue> simplify(Graph<T, NullValue, NullValue> graph, int parallelism) throws Exception {
        switch (this.value) {
            case DIRECTED: {
                graph = (Graph)graph.run((GraphAlgorithm)new org.apache.flink.graph.asm.simple.directed.Simplify().setParallelism(parallelism));
                break;
            }
            case UNDIRECTED: {
                graph = (Graph)graph.run((GraphAlgorithm)new org.apache.flink.graph.asm.simple.undirected.Simplify(false).setParallelism(parallelism));
                break;
            }
            case UNDIRECTED_CLIP_AND_FLIP: {
                graph = (Graph)graph.run((GraphAlgorithm)new org.apache.flink.graph.asm.simple.undirected.Simplify(true).setParallelism(parallelism));
            }
        }
        return graph;
    }

    public String getShortString() {
        switch (this.value) {
            case DIRECTED: {
                return "d";
            }
            case UNDIRECTED: {
                return "u";
            }
            case UNDIRECTED_CLIP_AND_FLIP: {
                return "\u0254";
            }
        }
        return "";
    }

    public static enum Ordering {
        NONE,
        DIRECTED,
        UNDIRECTED,
        UNDIRECTED_CLIP_AND_FLIP;

    }
}

