/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.scala.examples;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.GraphAlgorithm;
import org.apache.flink.graph.examples.data.ConnectedComponentsDefaultData;
import org.apache.flink.graph.library.GSAConnectedComponents;
import org.apache.flink.graph.scala.Graph;
import org.apache.flink.graph.scala.Graph$;
import org.apache.flink.graph.scala.examples.ConnectedComponents;
import org.apache.flink.graph.scala.examples.ConnectedComponents$;
import org.apache.flink.types.NullValue;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;

public final class ConnectedComponents$ {
    public static final ConnectedComponents$ MODULE$;
    private boolean fileOutput;
    private String edgesInputPath;
    private String outputPath;
    private Integer maxIterations;

    static {
        new ConnectedComponents$();
    }

    public void main(String[] args) {
        if (this.parseParameters(args)) {
            ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
            DataSet<Edge<Long, NullValue>> edges = this.getEdgesDataSet(env);
            Graph graph = Graph$.MODULE$.fromDataSet(edges, (MapFunction)new ConnectedComponents.InitVertices(), env, (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), ClassTag$.MODULE$.apply(Long.class), (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), ClassTag$.MODULE$.apply(Long.class), (TypeInformation)new ValueTypeInfo(NullValue.class), ClassTag$.MODULE$.apply(NullValue.class));
            org.apache.flink.api.java.DataSet components = (org.apache.flink.api.java.DataSet)graph.run((GraphAlgorithm)new GSAConnectedComponents(this.maxIterations()), TypeExtractor.createTypeInfo(org.apache.flink.api.java.DataSet.class), ClassTag$.MODULE$.apply(org.apache.flink.api.java.DataSet.class));
            if (this.fileOutput()) {
                components.writeAsCsv(this.outputPath(), "\n", ",");
                env.execute("Connected Components Example");
            } else {
                components.print();
            }
            return;
        }
    }

    private boolean fileOutput() {
        return this.fileOutput;
    }

    private void fileOutput_$eq(boolean x$1) {
        this.fileOutput = x$1;
    }

    private String edgesInputPath() {
        return this.edgesInputPath;
    }

    private void edgesInputPath_$eq(String x$1) {
        this.edgesInputPath = x$1;
    }

    private String outputPath() {
        return this.outputPath;
    }

    private void outputPath_$eq(String x$1) {
        this.outputPath = x$1;
    }

    private Integer maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(Integer x$1) {
        this.maxIterations = x$1;
    }

    private boolean parseParameters(String[] args) {
        if (args.length > 0) {
            if (args.length != 3) {
                System.err.println("Usage ConnectedComponents <edge path> <output path> <num iterations>");
            }
            this.fileOutput_$eq(true);
            this.edgesInputPath_$eq(args[0]);
            this.outputPath_$eq(args[1]);
            this.maxIterations_$eq(Predef$.MODULE$.int2Integer(2));
        } else {
            System.out.println("Executing ConnectedComponents example with default parameters and built-in default data.");
            System.out.println("  Provide parameters to read input data from files.");
            System.out.println("  See the documentation for the correct format of input files.");
            System.out.println("Usage ConnectedComponents <edge path> <output path> <num iterations>");
        }
        return true;
    }

    private DataSet<Edge<Long, NullValue>> getEdgesDataSet(ExecutionEnvironment env) {
        DataSet dataSet;
        if (this.fileOutput()) {
            List fields = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeInformation[]{BasicTypeInfo.getInfoFor(Long.class), BasicTypeInfo.getInfoFor(Long.class), new ValueTypeInfo(NullValue.class)}));
            Class<Edge> clazz = Edge.class;
            dataSet = env.readCsvFile(this.edgesInputPath(), "\n", "\t", env.readCsvFile$default$4(), env.readCsvFile$default$5(), env.readCsvFile$default$6(), env.readCsvFile$default$7(), env.readCsvFile$default$8(), env.readCsvFile$default$9(), ClassTag$.MODULE$.apply(Tuple2.class), (TypeInformation)new CaseClassTypeInfo<Tuple2<Long, Long>>(){

                public /* synthetic */ TypeInformation[] protected$types(anon.3 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple2<Long, Long>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.3 $outer;
                        private final ExecutionConfig executionConfig$1;
                        private final TypeSerializer[] fieldSerializers$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.executionConfig$1 = executionConfig$1;
                            this.fieldSerializers$1 = fieldSerializers$1;
                        }
                    });
                    return new CaseClassSerializer<Tuple2<Long, Long>>(this, fieldSerializers){

                        public Tuple2<Long, Long> createInstance(Object[] fields) {
                            return new Tuple2((Object)((Long)fields[0]), (Object)((Long)fields[1]));
                        }

                        public CaseClassSerializer<Tuple2<Long, Long>> createSerializerInstance(Class<Tuple2<Long, Long>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                            return (CaseClassSerializer)((Object)((Object)this)).getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                        }
                    };
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Edge<Long, NullValue> apply(Tuple2<Long, Long> edge) {
                    return new Edge(edge._1(), edge._2(), (Object)NullValue.getInstance());
                }
            }, (TypeInformation)new TupleTypeInfo(clazz, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(TypeInformation.class))), ClassTag$.MODULE$.apply(Edge.class));
        } else {
            Tuple2[] edgeData = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])ConnectedComponentsDefaultData.DEFAULT_EDGES).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Long, Long> apply(Object[] x0$1) {
                    Object[] objectArray = x0$1;
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                        Object x = ((SeqLike)option.get()).apply(0);
                        Object y = ((SeqLike)option.get()).apply(1);
                        Tuple2 tuple2 = new Tuple2((Object)((Long)x), (Object)((Long)y));
                        return tuple2;
                    }
                    throw new MatchError((Object)objectArray);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            List fields = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeInformation[]{BasicTypeInfo.getInfoFor(Long.class), BasicTypeInfo.getInfoFor(Long.class), new ValueTypeInfo(NullValue.class)}));
            Class<Edge> clazz = Edge.class;
            dataSet = env.fromCollection((Iterable)Predef$.MODULE$.wrapRefArray((Object[])edgeData), ClassTag$.MODULE$.apply(Tuple2.class), (TypeInformation)new CaseClassTypeInfo<Tuple2<Long, Long>>(){

                public /* synthetic */ TypeInformation[] protected$types(anon.4 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple2<Long, Long>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.4 $outer;
                        private final ExecutionConfig executionConfig$2;
                        private final TypeSerializer[] fieldSerializers$2;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.executionConfig$2 = executionConfig$2;
                            this.fieldSerializers$2 = fieldSerializers$2;
                        }
                    });
                    return new CaseClassSerializer<Tuple2<Long, Long>>(this, fieldSerializers){

                        public Tuple2<Long, Long> createInstance(Object[] fields) {
                            return new Tuple2((Object)((Long)fields[0]), (Object)((Long)fields[1]));
                        }

                        public CaseClassSerializer<Tuple2<Long, Long>> createSerializerInstance(Class<Tuple2<Long, Long>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                            return (CaseClassSerializer)((Object)((Object)this)).getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                        }
                    };
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Edge<Long, NullValue> apply(Tuple2<Long, Long> edge) {
                    return new Edge(edge._1(), edge._2(), (Object)NullValue.getInstance());
                }
            }, (TypeInformation)new TupleTypeInfo(clazz, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(TypeInformation.class))), ClassTag$.MODULE$.apply(Edge.class));
        }
        return dataSet;
    }

    private ConnectedComponents$() {
        MODULE$ = this;
        this.fileOutput = false;
        this.edgesInputPath = null;
        this.outputPath = null;
        this.maxIterations = ConnectedComponentsDefaultData.MAX_ITERATIONS;
    }
}

