/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.client.program.ProgramParametrizationException;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.drivers.AdamicAdar;
import org.apache.flink.graph.drivers.ClusteringCoefficient;
import org.apache.flink.graph.drivers.ConnectedComponents;
import org.apache.flink.graph.drivers.Driver;
import org.apache.flink.graph.drivers.EdgeList;
import org.apache.flink.graph.drivers.GraphMetrics;
import org.apache.flink.graph.drivers.HITS;
import org.apache.flink.graph.drivers.JaccardIndex;
import org.apache.flink.graph.drivers.PageRank;
import org.apache.flink.graph.drivers.TriangleListing;
import org.apache.flink.graph.drivers.input.CSV;
import org.apache.flink.graph.drivers.input.CirculantGraph;
import org.apache.flink.graph.drivers.input.CompleteGraph;
import org.apache.flink.graph.drivers.input.CycleGraph;
import org.apache.flink.graph.drivers.input.EchoGraph;
import org.apache.flink.graph.drivers.input.EmptyGraph;
import org.apache.flink.graph.drivers.input.GridGraph;
import org.apache.flink.graph.drivers.input.HypercubeGraph;
import org.apache.flink.graph.drivers.input.Input;
import org.apache.flink.graph.drivers.input.PathGraph;
import org.apache.flink.graph.drivers.input.RMatGraph;
import org.apache.flink.graph.drivers.input.SingletonEdgeGraph;
import org.apache.flink.graph.drivers.input.StarGraph;
import org.apache.flink.graph.drivers.output.Hash;
import org.apache.flink.graph.drivers.output.Output;
import org.apache.flink.graph.drivers.output.Print;
import org.apache.flink.graph.drivers.parameter.BooleanParameter;
import org.apache.flink.graph.drivers.parameter.Parameterized;
import org.apache.flink.graph.drivers.parameter.ParameterizedBase;
import org.apache.flink.graph.drivers.parameter.StringParameter;
import org.apache.flink.graph.drivers.transform.Transform;
import org.apache.flink.graph.drivers.transform.Transformable;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonEncoding;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.util.InstantiationUtil;

public class Runner
extends ParameterizedBase {
    private static final String INPUT = "input";
    private static final String ALGORITHM = "algorithm";
    private static final String OUTPUT = "output";
    private static ParameterizedFactory<Input> inputFactory = new ParameterizedFactory<CirculantGraph>().addClass(CirculantGraph.class).addClass(CompleteGraph.class).addClass(CSV.class).addClass(CycleGraph.class).addClass(EchoGraph.class).addClass(EmptyGraph.class).addClass(GridGraph.class).addClass(HypercubeGraph.class).addClass(PathGraph.class).addClass(RMatGraph.class).addClass(SingletonEdgeGraph.class).addClass(StarGraph.class);
    private static ParameterizedFactory<Driver> driverFactory = new ParameterizedFactory<AdamicAdar>().addClass(AdamicAdar.class).addClass(ClusteringCoefficient.class).addClass(ConnectedComponents.class).addClass(EdgeList.class).addClass(GraphMetrics.class).addClass(HITS.class).addClass(JaccardIndex.class).addClass(PageRank.class).addClass(TriangleListing.class);
    private static ParameterizedFactory<Output> outputFactory = new ParameterizedFactory<org.apache.flink.graph.drivers.output.CSV>().addClass(org.apache.flink.graph.drivers.output.CSV.class).addClass(Hash.class).addClass(Print.class);
    private final ParameterTool parameters;
    private final BooleanParameter disableObjectReuse = new BooleanParameter(this, "__disable_object_reuse");
    private final StringParameter jobDetailsPath = new StringParameter(this, "__job_details_path").setDefaultValue(null);
    private StringParameter jobName = new StringParameter(this, "__job_name").setDefaultValue(null);
    private ExecutionEnvironment env;
    private DataSet result;
    private String executionName;
    private Driver algorithm;
    private Output output;

    public Runner(String[] args) {
        this.parameters = ParameterTool.fromArgs((String[])args);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.env;
    }

    public DataSet getResult() {
        return this.result;
    }

    private static String getAlgorithmsListing() {
        StrBuilder strBuilder = new StrBuilder();
        strBuilder.appendNewLine().appendln("Select an algorithm to view usage: flink run examples/flink-gelly-examples_<version>.jar --algorithm <algorithm>").appendNewLine().appendln("Available algorithms:");
        for (Driver algorithm : driverFactory) {
            strBuilder.append("  ").appendFixedWidthPadRight((Object)algorithm.getName(), 30, ' ').append(algorithm.getShortDescription()).appendNewLine();
        }
        return strBuilder.toString();
    }

    private static String getAlgorithmUsage(String algorithmName) {
        StrBuilder strBuilder = new StrBuilder();
        Driver algorithm = driverFactory.get(algorithmName);
        strBuilder.appendNewLine().appendNewLine().appendln(algorithm.getLongDescription()).appendNewLine().append("usage: flink run examples/flink-gelly-examples_<version>.jar --algorithm ").append(algorithmName).append(" [algorithm options] --input <input> [input options] --output <output> [output options]").appendNewLine().appendNewLine().appendln("Available inputs:");
        for (Input input : inputFactory) {
            strBuilder.append("  --input ").append(input.getName()).append(" ").appendln(input.getUsage());
        }
        String algorithmParameterization = algorithm.getUsage();
        if (algorithmParameterization.length() > 0) {
            strBuilder.appendNewLine().appendln("Algorithm configuration:").append("  ").appendln(algorithm.getUsage());
        }
        strBuilder.appendNewLine().appendln("Available outputs:");
        for (Output output : outputFactory) {
            strBuilder.append("  --output ").append(output.getName()).append(" ").appendln(output.getUsage());
        }
        return strBuilder.appendNewLine().toString();
    }

    private void parameterize(Parameterized parameterized) {
        try {
            parameterized.configure(this.parameters);
        }
        catch (RuntimeException ex) {
            throw new ProgramParametrizationException(ex.getMessage());
        }
    }

    public Runner run() throws Exception {
        this.env = ExecutionEnvironment.getExecutionEnvironment();
        ExecutionConfig config = this.env.getConfig();
        config.disableForceAvro();
        config.disableForceKryo();
        config.setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)this.parameters);
        this.parameterize(this);
        try {
            this.configure(this.parameters);
        }
        catch (RuntimeException ex) {
            throw new ProgramParametrizationException(ex.getMessage());
        }
        if (((Boolean)this.disableObjectReuse.getValue()).booleanValue()) {
            config.disableObjectReuse();
        } else {
            config.enableObjectReuse();
        }
        if (!this.parameters.has(ALGORITHM)) {
            throw new ProgramParametrizationException(Runner.getAlgorithmsListing());
        }
        String algorithmName = this.parameters.get(ALGORITHM);
        this.algorithm = driverFactory.get(algorithmName);
        if (this.algorithm == null) {
            throw new ProgramParametrizationException("Unknown algorithm name: " + algorithmName);
        }
        if (!this.parameters.has(INPUT)) {
            if (!this.parameters.has(OUTPUT)) {
                throw new ProgramParametrizationException(Runner.getAlgorithmUsage(algorithmName));
            }
            throw new ProgramParametrizationException("No input given");
        }
        this.parameterize(this.algorithm);
        String inputName = this.parameters.get(INPUT);
        Input input = inputFactory.get(inputName);
        if (input == null) {
            throw new ProgramParametrizationException("Unknown input type: " + inputName);
        }
        this.parameterize(input);
        if (!this.parameters.has(OUTPUT)) {
            throw new ProgramParametrizationException("No output given");
        }
        String outputName = this.parameters.get(OUTPUT);
        this.output = outputFactory.get(outputName);
        if (this.output == null) {
            throw new ProgramParametrizationException("Unknown output type: " + outputName);
        }
        this.parameterize(this.output);
        ArrayList<Transform> transforms = new ArrayList<Transform>();
        if (input instanceof Transformable) {
            transforms.addAll(((Transformable)((Object)input)).getTransformers());
        }
        if (this.algorithm instanceof Transformable) {
            transforms.addAll(((Transformable)((Object)this.algorithm)).getTransformers());
        }
        for (Transform transform : transforms) {
            this.parameterize(transform);
        }
        if (this.parameters.getUnrequestedParameters().size() > 0) {
            throw new ProgramParametrizationException("Unrequested parameters: " + this.parameters.getUnrequestedParameters());
        }
        Graph graph = input.create(this.env);
        for (Transform transform : transforms) {
            graph = (Graph)transform.transformInput(graph);
        }
        this.result = this.algorithm.plan(graph);
        this.executionName = this.jobName.getValue() != null ? (String)this.jobName.getValue() + ": " : "";
        this.executionName = this.executionName + input.getIdentity() + " \u21e8 " + algorithmName + " \u21e8 " + this.output.getName();
        if (transforms.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer(this.executionName).append(" [");
            for (Transform transform : transforms) {
                stringBuffer.append(transform.getIdentity());
            }
            this.executionName = stringBuffer.append("]").toString();
        }
        if (this.output == null) {
            throw new ProgramParametrizationException("Unknown output type: " + outputName);
        }
        try {
            this.output.configure(this.parameters);
        }
        catch (RuntimeException runtimeException) {
            throw new ProgramParametrizationException(runtimeException.getMessage());
        }
        if (this.result != null && transforms.size() > 0) {
            Collections.reverse(transforms);
            for (Transform transform : transforms) {
                this.result = (DataSet)transform.transformResult(this.result);
            }
        }
        return this;
    }

    private void execute() throws Exception {
        if (this.result == null) {
            this.env.execute(this.executionName);
        } else {
            this.output.write(this.executionName.toString(), System.out, this.result);
        }
        System.out.println();
        this.algorithm.printAnalytics(System.out);
        if (this.jobDetailsPath.getValue() != null) {
            Runner.writeJobDetails(this.env, (String)this.jobDetailsPath.getValue());
        }
    }

    private static void writeJobDetails(ExecutionEnvironment env, String jobDetailsPath) throws IOException {
        JobExecutionResult result = env.getLastJobExecutionResult();
        File jsonFile = new File(jobDetailsPath);
        try (JsonGenerator json = new JsonFactory().createGenerator(jsonFile, JsonEncoding.UTF8);){
            json.writeStartObject();
            json.writeObjectFieldStart("Apache Flink");
            json.writeStringField("version", EnvironmentInformation.getVersion());
            json.writeStringField("commit ID", EnvironmentInformation.getRevisionInformation().commitId);
            json.writeStringField("commit date", EnvironmentInformation.getRevisionInformation().commitDate);
            json.writeEndObject();
            json.writeStringField("job_id", result.getJobID().toString());
            json.writeNumberField("runtime_ms", result.getNetRuntime());
            json.writeObjectFieldStart("parameters");
            for (Map.Entry entry : env.getConfig().getGlobalJobParameters().toMap().entrySet()) {
                json.writeStringField((String)entry.getKey(), (String)entry.getValue());
            }
            json.writeEndObject();
            json.writeObjectFieldStart("accumulators");
            for (Map.Entry entry : result.getAllAccumulatorResults().entrySet()) {
                json.writeStringField((String)entry.getKey(), entry.getValue().toString());
            }
            json.writeEndObject();
            json.writeEndObject();
        }
    }

    public static void main(String[] args) throws Exception {
        new Runner(args).run().execute();
    }

    private static class ParameterizedFactory<T extends Parameterized>
    implements Iterable<T> {
        private List<Class<? extends T>> classes = new ArrayList<Class<? extends T>>();

        private ParameterizedFactory() {
        }

        public ParameterizedFactory<T> addClass(Class<? extends T> cls) {
            this.classes.add(cls);
            return this;
        }

        public T get(String name) {
            for (Parameterized instance : this) {
                if (!name.equalsIgnoreCase(instance.getName())) continue;
                return (T)instance;
            }
            return null;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int index;

                @Override
                public boolean hasNext() {
                    return this.index < classes.size();
                }

                @Override
                public T next() {
                    return (Parameterized)InstantiationUtil.instantiate((Class)((Class)classes.get(this.index++)));
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

