/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.drivers;

import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAlgorithm;
import org.apache.flink.graph.drivers.DriverBase;
import org.apache.flink.graph.drivers.parameter.BooleanParameter;
import org.apache.flink.graph.drivers.parameter.DoubleParameter;
import org.apache.flink.types.CopyableValue;

public class AdamicAdar<K extends CopyableValue<K>, VV, EV>
extends DriverBase<K, VV, EV> {
    private DoubleParameter minRatio = new DoubleParameter(this, "minimum_ratio").setDefaultValue(0.0).setMinimumValue(0.0, true);
    private DoubleParameter minScore = new DoubleParameter(this, "minimum_score").setDefaultValue(0.0).setMinimumValue(0.0, true);
    private BooleanParameter mirrorResults = new BooleanParameter(this, "mirror_results");

    @Override
    public String getShortDescription() {
        return "similarity score weighted by centerpoint degree";
    }

    @Override
    public String getLongDescription() {
        return WordUtils.wrap((String)new StrBuilder().appendln("Adamic-Adar measures the similarity between vertex neighborhoods and is computed as the sum of the inverse logarithm of centerpoint degree over shared neighbors.").appendNewLine().append("The algorithm result contains two vertex IDs and the similarity score.").toString(), (int)80);
    }

    @Override
    public DataSet plan(Graph<K, VV, EV> graph) throws Exception {
        return (DataSet)graph.run((GraphAlgorithm)new org.apache.flink.graph.library.similarity.AdamicAdar().setMinimumRatio(((Double)this.minRatio.getValue()).floatValue()).setMinimumScore(((Double)this.minScore.getValue()).floatValue()).setMirrorResults(((Boolean)this.mirrorResults.getValue()).booleanValue()).setParallelism(((Long)this.parallelism.getValue()).intValue()));
    }
}

