/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.drivers.input;

import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.drivers.input.GeneratedMultiGraph;
import org.apache.flink.graph.drivers.parameter.BooleanParameter;
import org.apache.flink.graph.drivers.parameter.DoubleParameter;
import org.apache.flink.graph.drivers.parameter.LongParameter;
import org.apache.flink.graph.generator.random.JDKRandomGeneratorFactory;
import org.apache.flink.graph.generator.random.RandomGenerableFactory;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;

public class RMatGraph
extends GeneratedMultiGraph {
    private LongParameter scale = new LongParameter(this, "scale").setDefaultValue(10L).setMinimumValue(1L);
    private LongParameter edgeFactor = new LongParameter(this, "edge_factor").setDefaultValue(16L).setMinimumValue(1L);
    private DoubleParameter a = new DoubleParameter(this, "a").setDefaultValue(0.57f).setMinimumValue(0.0, false);
    private DoubleParameter b = new DoubleParameter(this, "b").setDefaultValue(0.19f).setMinimumValue(0.0, false);
    private DoubleParameter c = new DoubleParameter(this, "c").setDefaultValue(0.19f).setMinimumValue(0.0, false);
    private BooleanParameter noiseEnabled = new BooleanParameter(this, "noise_enabled");
    private DoubleParameter noise = new DoubleParameter(this, "noise").setDefaultValue(0.1f).setMinimumValue(0.0, true).setMaximumValue(2.0, true);
    private LongParameter seed = new LongParameter(this, "seed").setDefaultValue(5435701917232523172L);

    @Override
    public String getIdentity() {
        return this.getName() + " (s" + this.scale + "e" + this.edgeFactor + this.getSimplifyShortString() + ")";
    }

    @Override
    protected long vertexCount() {
        return 1L << (int)((Long)this.scale.getValue()).longValue();
    }

    @Override
    public Graph<LongValue, NullValue, NullValue> generate(ExecutionEnvironment env) throws Exception {
        JDKRandomGeneratorFactory rnd = new JDKRandomGeneratorFactory(((Long)this.seed.getValue()).longValue());
        long vertexCount = 1L << (int)((Long)this.scale.getValue()).longValue();
        long edgeCount = vertexCount * (Long)this.edgeFactor.getValue();
        return new org.apache.flink.graph.generator.RMatGraph(env, (RandomGenerableFactory)rnd, vertexCount, edgeCount).setConstants(((Double)this.a.getValue()).floatValue(), ((Double)this.b.getValue()).floatValue(), ((Double)this.c.getValue()).floatValue()).setNoise(((Boolean)this.noiseEnabled.getValue()).booleanValue(), ((Double)this.noise.getValue()).floatValue()).setParallelism(((Long)this.parallelism.getValue()).intValue()).generate();
    }
}

